/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.DesignHierarchyInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderDesignHierarchyAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.DesignHierarchy;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.Instance;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.Module;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.visitors.FilesToAnalyzeAwareVisitor;
import com.lintyservices.utils.FileUtils;
import java.io.File;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL1012")
public class TooManyModulesInstantiatedCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderDesignHierarchyAwareVisitor,
FilesToAnalyzeAwareVisitor {
    private DesignHierarchy hierarchy;
    private Set<File> filesToAnalyze;
    private static final int DEFAULT_MAX = 4;
    @RuleProperty(key="max", description="Maximum number of allowed dependencies", type="INTEGER", defaultValue="4")
    private int max = 4;

    @Override
    public void setDesignHierarchy(DesignHierarchyInterface hierarchy) {
        this.hierarchy = (DesignHierarchy)hierarchy;
    }

    @Override
    public void setFilesToAnalyze(Set<File> filesToAnalyze) {
        this.filesToAnalyze = filesToAnalyze;
    }

    @Override
    public final void retrieveIssues() {
        this.checkForIssue(this.hierarchy.top());
    }

    private void checkForIssue(Instance instance) {
        if (instance.module().location() != null && FileUtils.contains(this.filesToAnalyze, instance.module().location().file())) {
            Set<Module> instantiatedModules = instance.instantiatedModules();
            if (instantiatedModules.size() > this.max) {
                this.issues().addPreciseIssue(instance.location(), String.format("Reduce the number of dependent modules. Actual: %d. Allowed: %d", instantiatedModules.size(), this.max), instantiatedModules.stream().map(i -> {
                    if (i.location() != null && FileUtils.contains(this.filesToAnalyze, i.location().file())) {
                        return new HdlIssueLocation(i.location(), i.name());
                    }
                    return new HdlIssueLocation(instance.location(), i.name() + " (not in source code)");
                }).toList());
            }
            instance.instantiates().forEach(this::checkForIssue);
        }
    }
}

