/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.objects.FSMsInterface;
import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderFsmsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.fsm.Fsms;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import com.lintyservices.sonar.plugins.vhdl.api.bugfinder.fsm.Fsm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="HDL1023")
public class TrackFsmCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderFsmsAwareVisitor {
    private Fsms fsms;

    @Override
    public void setFsms(FSMsInterface fsms) {
        this.fsms = (Fsms)fsms;
    }

    @Override
    public final void retrieveIssues() {
        for (Fsm fsm : this.fsms.fsms()) {
            this.issues().addPreciseIssueWithFlows(fsm.location(), String.format("Finite state machine: %s (States: %d, Input signals: %d, Output signals: %d)", fsm.name(), fsm.numberOfStates(), fsm.numberOfInputSignals(), fsm.numberOfOutputSignals()), this.secondaryLocations(fsm));
        }
    }

    private List<List<? extends IssueLocationInterface>> secondaryLocations(Fsm fsm) {
        ArrayList<HdlIssueLocation> secondaryLocations = new ArrayList<HdlIssueLocation>();
        secondaryLocations.addAll(fsm.outputSignals().stream().map(s -> new HdlIssueLocation(s.location(), "Output signal: " + s.name())).toList());
        secondaryLocations.addAll(fsm.inputSignals().stream().flatMap(Collection::stream).collect(Collectors.toSet()).stream().map(s -> new HdlIssueLocation(s.location(), "Input signal: " + s.name())).toList());
        if (fsm.type() != null) {
            secondaryLocations.add(new HdlIssueLocation(fsm.type().file(), (Tree)fsm.type().tree(), "Type"));
        }
        return List.of(secondaryLocations);
    }
}

