/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderUnregisteredTopLevelInputPortsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.UnregisteredPorts;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.visitors.TopModuleNameAwareVisitor;
import com.lintyservices.yosys.objects.YosysPort;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL1031")
public class UnregisteredTopLevelInputPortsCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderUnregisteredTopLevelInputPortsAwareVisitor,
TopModuleNameAwareVisitor {
    private Set<YosysPort> unregisteredInputPorts;
    private String topModuleName;
    private static final int DEFAULT_MIN = 1;
    @RuleProperty(key="min", description="Minimum number of registration levels.", type="INTEGER", defaultValue="1")
    public int min = 1;

    @Override
    public void setUnregisteredInputPorts(Set<YosysPort> unregisteredInputPorts) {
        this.unregisteredInputPorts = unregisteredInputPorts;
    }

    @Override
    public void setTopModuleName(String topModuleName) {
        this.topModuleName = topModuleName;
    }

    @Override
    public final void retrieveIssues() {
        Set<YosysPort> ports = this.unregisteredInputPorts.stream().filter(p -> this.topModuleName.equals(p.module().name())).collect(Collectors.toSet());
        UnregisteredPorts.createSingleDimensionPortIssues(this.issues(), ports, false);
    }
}

