/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.bugfinder;

import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderUnregisteredOutputPortsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.HdlCrossFileBugFinderCheck;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.UnregisteredPorts;
import com.lintyservices.sonar.plugins.hdl.checks.helpers.visitors.TopModuleNameAwareVisitor;
import com.lintyservices.yosys.objects.YosysPort;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="HDL1008")
public class UnregisteredTopLevelOutputPortsCheck
extends HdlCrossFileBugFinderCheck
implements BugFinderUnregisteredOutputPortsAwareVisitor,
TopModuleNameAwareVisitor {
    private Set<YosysPort> unregisteredOutputPorts;
    private String topModuleName;

    @Override
    public void setUnregisteredOutputPorts(Set<YosysPort> unregisteredOutputPorts) {
        this.unregisteredOutputPorts = unregisteredOutputPorts;
    }

    @Override
    public void setTopModuleName(String topModuleName) {
        this.topModuleName = topModuleName;
    }

    @Override
    public final void retrieveIssues() {
        Set<YosysPort> ports = this.unregisteredOutputPorts.stream().filter(p -> this.topModuleName.equals(p.module().name())).collect(Collectors.toSet());
        UnregisteredPorts.createSingleDimensionPortIssues(this.issues(), ports, true);
        UnregisteredPorts.createMultiDimensionPortIssues(this.issues(), ports, true);
    }
}

