/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.linter;

import com.lintyservices.sonar.plugins.hdl.api.HdlCheck;
import com.lintyservices.sonar.plugins.hdl.visitors.FileCheck;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.sonar.check.Rule;

@Rule(key="HDL001")
public class MissingNewLineAtEndOfFileCheck
extends FileCheck
implements HdlCheck,
FreeHdlDesignerCheck {
    @Override
    public void retrieveIssuesOnFile(File file) {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            if (randomAccessFile.length() != 0L && !MissingNewLineAtEndOfFileCheck.endsWithNewline(randomAccessFile)) {
                this.issues().addFileIssue(file, "Add an empty new line at the end of this file.");
            }
        }
        catch (IOException e) {
            throw new LintyException("Check " + this.getClass().getAnnotation(Rule.class).key() + ": Error while reading " + FileUtils.sanitizedPath(file.getAbsolutePath()), e);
        }
    }

    private static boolean endsWithNewline(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile.length() < 1L) {
            return false;
        }
        randomAccessFile.seek(randomAccessFile.length() - 1L);
        byte[] chars = new byte[1];
        if (randomAccessFile.read(chars) < 1) {
            return false;
        }
        String ch = new String(chars);
        return "\n".equals(ch) || "\r".equals(ch);
    }
}

