/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.active.linter;

import com.google.common.io.Files;
import com.lintyservices.sonar.plugins.hdl.api.HdlCheck;
import com.lintyservices.sonar.plugins.hdl.visitors.FileCheck;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.linty.language.visitors.CharsetAwareVisitor;
import com.lintyservices.utils.LintyException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="HDL005")
public class TooLongLineCheck
extends FileCheck
implements HdlDesignerCheck,
HdlCheck,
CharsetAwareVisitor {
    private static final int DEFAULT_MAXIMUM_LINE_LENGTH = 120;
    @RuleProperty(key="max", description="The maximum authorized line length.", defaultValue="120")
    public int max = 120;
    private Charset charset;

    @Override
    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void retrieveIssuesOnFile(File file) {
        List<String> lines;
        try {
            lines = Files.readLines(file, this.charset);
        }
        catch (IOException e) {
            throw new LintyException("Cannot read file: " + file.getAbsolutePath(), e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.length() <= this.max || line.contains("`include")) continue;
            this.issues().addLineIssue(file, i + 1, MessageFormat.format("Split this {0} characters long line (which is greater than {1} authorized).", line.length(), this.max));
        }
    }
}

