/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.helpers;

import com.lintyservices.sonar.plugins.hdl.checks.helpers.Ports;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssues;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.RangeUtils;
import com.lintyservices.yosys.objects.YosysPort;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnconnectedPorts {
    public static void createSingleDimensionPortIssues(HdlIssues issues, Set<YosysPort> ports, String portType) {
        for (YosysPort port : Ports.getSingleDimensionPorts(ports)) {
            issues.addPreciseIssue(port.location(), UnconnectedPorts.getSingleDimensionPortIssueMessage(port, portType));
        }
    }

    public static void createMultiDimensionPortIssues(HdlIssues issues, Set<YosysPort> ports, String portType) {
        for (Map.Entry<File, Map<String, List<YosysPort>>> entry : Ports.getMultiDimensionPorts(ports)) {
            for (Map.Entry<String, List<YosysPort>> port : entry.getValue().entrySet()) {
                issues.addPreciseIssue(port.getValue().get(0).location(), UnconnectedPorts.getMultiDimensionPortIssueMessage(port, portType));
            }
        }
    }

    private static String getSingleDimensionPortIssueMessage(YosysPort port, String portType) {
        return String.format("%s%s %s port is %sunconnected.%s Update design to remove this unconnected %s port.", port.name(), port.width() != 1 ? "(" + port.range() + ")" : "", portType, port.bitOffsets().isEmpty() ? "" : "partially ", port.bitOffsets().isEmpty() ? "" : " Unconnected bit offsets: " + RangeUtils.getRangesStringFromIntegers(new HashSet<Integer>(port.bitOffsets()), port.upto()) + ".", portType);
    }

    private static String getMultiDimensionPortIssueMessage(Map.Entry<String, List<YosysPort>> entry, String portType) {
        StringBuilder message = new StringBuilder().append(entry.getKey()).append(" ").append(portType).append(" port is (partially) unconnected. ");
        for (YosysPort portDimension : entry.getValue()) {
            String bitOffsets = "all";
            if (!portDimension.bitOffsets().isEmpty()) {
                bitOffsets = RangeUtils.getRangesStringFromIntegers(new HashSet<Integer>(portDimension.bitOffsets()), portDimension.upto());
            }
            message.append("Dimension: ").append(portDimension.dimensions()).append((String)(portDimension.width() != 1 ? "(" + portDimension.range() + ")" : "")).append(" => Unconnected bit offsets: ").append(bitOffsets).append(". ");
        }
        message.append("Update design to remove this unconnected ").append(portType).append(" port.");
        return message.toString();
    }
}

