/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.checks.helpers;

import com.lintyservices.sonar.plugins.hdl.checks.helpers.Ports;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssues;
import com.lintyservices.sonar.plugins.vhdl.checks.helpers.RangeUtils;
import com.lintyservices.yosys.objects.YosysCell;
import com.lintyservices.yosys.objects.YosysPort;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class UnregisteredPorts {
    public static void createSingleDimensionPortIssues(HdlIssues issues, Set<YosysPort> ports, boolean outputPort) {
        if (outputPort) {
            for (YosysPort port : Ports.getSingleDimensionPorts(ports)) {
                issues.addPreciseIssue(port.location(), UnregisteredPorts.getSingleDimensionPortIssueMessageForOutputPort(port), UnregisteredPorts.getSingleDimensionPortSecondaryLocations(port));
            }
        } else {
            for (YosysPort port : ports) {
                for (Map.Entry<Integer, Set<Integer>> entry : port.missingRegistrationBits().entrySet()) {
                    issues.addPreciseIssue(port.location(), String.format("'%s' input port is missing %d level%s of input registration for bit offset%s: %s.", port.name(), entry.getKey(), entry.getKey() > 1 ? "s" : "", entry.getValue().size() > 1 ? "s" : "", RangeUtils.getRangesStringFromIntegers(entry.getValue(), port.upto())), UnregisteredPorts.getSingleDimensionPortSecondaryLocations(port));
                }
            }
        }
    }

    public static void createMultiDimensionPortIssues(HdlIssues issues, Set<YosysPort> ports, boolean outputPort) {
        if (outputPort) {
            for (Map.Entry<File, Map<String, List<YosysPort>>> entry : Ports.getMultiDimensionPorts(ports)) {
                for (Map.Entry<String, List<YosysPort>> port : entry.getValue().entrySet()) {
                    issues.addPreciseIssue(port.getValue().get(0).location(), UnregisteredPorts.getMultiDimensionPortIssueMessageForOutputPort(port), UnregisteredPorts.getMultiDimensionPortSecondaryLocations(port));
                }
            }
        }
    }

    private static String getSingleDimensionPortIssueMessageForOutputPort(YosysPort port) {
        return String.format("'%s%s' output port is %sunregistered.%s. Update design to remove combinational elements from this output signal path.", port.name(), port.width() != 1 ? "(" + port.range() + ")" : "", port.bitOffsets().isEmpty() ? "" : "partially ", port.bitOffsets().isEmpty() ? "" : " Unregistered bit offsets: " + RangeUtils.getRangesStringFromIntegers(new HashSet<Integer>(port.bitOffsets()), port.upto()));
    }

    private static List<HdlIssueLocation> getSingleDimensionPortSecondaryLocations(YosysPort port) {
        ArrayList<HdlIssueLocation> secondaryLocations = new ArrayList<HdlIssueLocation>();
        for (YosysCell cell : port.connectedCells()) {
            if (cell.location() == null) continue;
            secondaryLocations.add(new HdlIssueLocation(cell.location(), "Connected cell: " + cell.beautifulType()));
        }
        return secondaryLocations;
    }

    private static String getMultiDimensionPortIssueMessageForOutputPort(Map.Entry<String, List<YosysPort>> entry) {
        StringBuilder message = new StringBuilder().append(String.format(" '%s' output port is (partially) unregistered. ", entry.getKey()));
        for (YosysPort portDimension : entry.getValue()) {
            String bitOffsets = "all";
            if (!portDimension.bitOffsets().isEmpty()) {
                bitOffsets = RangeUtils.getRangesStringFromIntegers(new HashSet<Integer>(portDimension.bitOffsets()), portDimension.upto());
            }
            message.append("Dimension: ").append(portDimension.dimensions()).append((String)(portDimension.width() != 1 ? "(" + portDimension.range() + ")" : "")).append(" => Unregistered bit offsets: ").append(bitOffsets).append(". ");
        }
        message.append(" Update design to remove combinational elements from this output signal path.");
        return message.toString();
    }

    private static List<HdlIssueLocation> getMultiDimensionPortSecondaryLocations(Map.Entry<String, List<YosysPort>> entry) {
        ArrayList<HdlIssueLocation> secondaryLocations = new ArrayList<HdlIssueLocation>();
        for (YosysCell cell : entry.getValue().stream().map(YosysPort::connectedCells).flatMap(Collection::stream).collect(Collectors.toSet())) {
            if (cell.location() == null) continue;
            secondaryLocations.add(new HdlIssueLocation(cell.location(), "Connected cell: " + cell.beautifulType()));
        }
        return secondaryLocations;
    }
}

