/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.clock;

import com.lintyservices.sonar.plugins.bugfinder.objects.clockdomain.CDCsInterface;
import com.lintyservices.sonar.plugins.hdl.logiccircuit.DCUtils;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.objects.YosysCDC;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CDCs
implements CDCsInterface {
    private final List<YosysCDC> cdcs;
    private final DCUtils dcUtils;

    public CDCs(Set<YosysCDC> allCDCs, DCUtils dcUtils) {
        this.dcUtils = dcUtils;
        this.cdcs = this.filterCDCs(allCDCs);
    }

    public List<YosysCDC> asList() {
        return this.cdcs;
    }

    public Map<String, List<YosysCDC>> asMap() {
        HashMap<String, List<YosysCDC>> map = new HashMap<String, List<YosysCDC>>();
        for (YosysCDC cdc : this.cdcs) {
            String key = cdc.fullOriginClockDomain() + ";" + cdc.fullTargetClockDomain();
            if (map.containsKey(key)) {
                ((List)map.get(key)).add(cdc);
                continue;
            }
            ArrayList<YosysCDC> cdcList = new ArrayList<YosysCDC>();
            cdcList.add(cdc);
            map.put(key, cdcList);
        }
        return map;
    }

    public int size() {
        return this.cdcs.size();
    }

    public DCUtils dcUtils() {
        return this.dcUtils;
    }

    private List<YosysCDC> filterCDCs(Set<YosysCDC> allCDCs) {
        return allCDCs.stream().filter(c -> FileUtils.contains(this.dcUtils.filesToAnalyze(), c.origin().location().file()) || FileUtils.contains(this.dcUtils.filesToAnalyze(), c.target().location().file())).sorted(Comparator.comparingInt(YosysCDC::id)).toList();
    }
}

