/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.clock;

import com.lintyservices.sonar.plugins.bugfinder.objects.clockdomain.ClockDomainsInterface;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.hdl.logiccircuit.ClockAndResetDomainUtils;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.yosys.helpers.clock.ClockDirection;
import com.lintyservices.yosys.objects.YosysClockDomain;
import com.lintyservices.yosys.objects.YosysClockManagementModule;
import com.lintyservices.yosys.objects.YosysClockOrResetDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ClockDomains
implements ClockDomainsInterface {
    private final List<YosysClockDomain> clockDomains;
    @Nullable
    private final YosysClockManagementModule clockManagementModule;
    private final ClockAndResetDomainUtils clockAndResetDomainUtils;

    public ClockDomains(Set<YosysClockDomain> allClockDomains, @Nullable YosysClockManagementModule clockManagementModule, ClockAndResetDomainUtils clockAndResetDomainUtils) {
        this.clockManagementModule = clockManagementModule;
        this.clockAndResetDomainUtils = clockAndResetDomainUtils;
        this.clockDomains = this.sortedClockDomains(allClockDomains);
    }

    public List<YosysClockDomain> clockDomains() {
        return this.clockDomains;
    }

    public int size() {
        int count = 0;
        for (YosysClockDomain domain : this.clockDomains) {
            if (domain.rising()) {
                ++count;
            }
            if (!domain.falling()) continue;
            ++count;
        }
        return count;
    }

    @Nullable
    public YosysClockManagementModule clockManagementModule() {
        return this.clockManagementModule;
    }

    public List<List<? extends IssueLocationInterface>> flows(HdlIssueLocation mainIssueLocation) {
        ArrayList<List<? extends IssueLocationInterface>> flows = new ArrayList<List<? extends IssueLocationInterface>>();
        for (YosysClockDomain clockDomain : this.clockDomains) {
            if (clockDomain.rising()) {
                flows.add(this.flow(clockDomain, mainIssueLocation, ClockDirection.RISING));
            }
            if (!clockDomain.falling()) continue;
            flows.add(this.flow(clockDomain, mainIssueLocation, ClockDirection.FALLING));
        }
        return flows;
    }

    public List<? extends IssueLocationInterface> flow(YosysClockDomain clockDomain, HdlIssueLocation location, ClockDirection direction) {
        ArrayList<HdlIssueLocation> flow = new ArrayList<HdlIssueLocation>(this.clockAndResetDomainUtils.originLocations(clockDomain));
        flow.add(new HdlIssueLocation(location, direction.value().substring(0, 1).toUpperCase() + direction.value().substring(1) + " usage"));
        return flow;
    }

    public ClockAndResetDomainUtils clockAndResetDomainUtils() {
        return this.clockAndResetDomainUtils;
    }

    private List<YosysClockDomain> sortedClockDomains(Set<YosysClockDomain> allClockDomains) {
        List<YosysClockDomain> sorted2 = allClockDomains.stream().sorted(Comparator.comparingInt(YosysClockOrResetDomain::modules).thenComparingInt(YosysClockOrResetDomain::flipFlops)).collect(Collectors.toList());
        Collections.reverse(sorted2);
        return sorted2;
    }
}

