/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.combinationalloop;

import com.lintyservices.sonar.plugins.bugfinder.objects.CombinationalLoopsInterface;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.objects.YosysCombinationalLoop;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class CombinationalLoops
implements CombinationalLoopsInterface {
    private final Set<YosysCombinationalLoop> allCombinationalLoops;
    private final List<YosysCombinationalLoop> combinationalLoops;
    private final Set<File> filesToAnalyze;

    public CombinationalLoops(Set<YosysCombinationalLoop> allCombinationalLoops, Set<File> filesToAnalyze) {
        this.allCombinationalLoops = allCombinationalLoops;
        this.filesToAnalyze = filesToAnalyze;
        this.combinationalLoops = this.filterCombinationalLoops();
    }

    public int size() {
        return this.combinationalLoops().size();
    }

    public List<YosysCombinationalLoop> combinationalLoops() {
        return this.combinationalLoops;
    }

    private List<YosysCombinationalLoop> filterCombinationalLoops() {
        return this.allCombinationalLoops.stream().filter(c -> FileUtils.contains(this.filesToAnalyze, c.signal().location().file())).sorted(Comparator.comparingInt(YosysCombinationalLoop::id)).toList();
    }
}

