/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.designhierarchy;

import com.lintyservices.slang.trees.HierarchicalInstance;
import com.lintyservices.slang.trees.ModuleDeclaration;
import com.lintyservices.sonar.plugins.bugfinder.objects.DesignHierarchyInterface;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.Instance;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.Module;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ArchitectureTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ComponentInstantiationTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ComponentTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.EntityTreeFile;
import com.lintyservices.yosys.objects.YosysClockManagementModule;
import com.lintyservices.yosys.objects.YosysModuleInstantiation;
import com.lintyservices.yosys.objects.YosysResetManagementModule;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DesignHierarchy
implements DesignHierarchyInterface {
    private final Instance top;
    private final List<Instance> allInstances;

    public DesignHierarchy(YosysModuleInstantiation hierarchy, @Nullable YosysClockManagementModule clockManagementModule, @Nullable YosysResetManagementModule resetManagementModule, Set<EntityTreeFile> entityTreeFiles, Set<ArchitectureTreeFile> architectureTreeFiles, Set<ComponentInstantiationTreeFile> componentInstantiationTreeFiles, Set<ComponentTreeFile> componentTreeFiles, List<ModuleDeclaration> moduleDeclarations, List<HierarchicalInstance> hierarchicalInstances, Set<String> explicitlySetParameters, Set<File> fileToAnalyze) {
        this.top = new Instance(hierarchy, null, clockManagementModule, resetManagementModule, entityTreeFiles, architectureTreeFiles, componentInstantiationTreeFiles, componentTreeFiles, moduleDeclarations, hierarchicalInstances, explicitlySetParameters, fileToAnalyze);
        this.allInstances = new ArrayList<Instance>();
        this.gatherAllInstantiations(Set.of(this.top));
    }

    public Instance top() {
        return this.top;
    }

    public int numberOfInstances() {
        return this.allInstances.stream().filter(i -> !i.isThirdParty()).collect(Collectors.toSet()).size();
    }

    public int numberOfModules() {
        HashSet<Module> modules = new HashSet<Module>();
        for (Instance instance : this.allInstances.stream().filter(i -> !i.isThirdParty()).collect(Collectors.toSet())) {
            modules.addAll(instance.instantiatedModulesInSourceCode());
        }
        return modules.size() + 1;
    }

    public List<Instance> allInstances() {
        return this.allInstances;
    }

    private void gatherAllInstantiations(Set<Instance> instantiations) {
        this.allInstances.addAll(instantiations);
        for (Instance child : instantiations) {
            this.gatherAllInstantiations(child.instantiates());
        }
    }
}

