/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.designhierarchy;

import com.lintyservices.slang.trees.HierarchicalInstance;
import com.lintyservices.slang.trees.HierarchyInstantiation;
import com.lintyservices.slang.trees.ModuleDeclaration;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.Module;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.Parameter;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ArchitectureTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ComponentInstantiationTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.ComponentTreeFile;
import com.lintyservices.sonar.plugins.vhdl.api.treefile.EntityTreeFile;
import com.lintyservices.sonar.plugins.vhdl.parser.AssociationElementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.AssociationListTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ComponentDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.ComponentInstantiationStatementTree;
import com.lintyservices.sonar.plugins.vhdl.parser.EntityDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IdentifierTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceDeclarationTree;
import com.lintyservices.sonar.plugins.vhdl.parser.InterfaceSignalDeclarationTree;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.objects.YosysClockManagementModule;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysModule;
import com.lintyservices.yosys.objects.YosysModuleInstantiation;
import com.lintyservices.yosys.objects.YosysModuleInstantiationParameter;
import com.lintyservices.yosys.objects.YosysResetManagementModule;
import com.lintyservices.yosys.objects.YosysScopes;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class Instance {
    private final String id;
    private final String name;
    @Nullable
    private final String locationAsMarkdown;
    private final String doxygenComments;
    private final Set<Parameter> parameters;
    @Nullable
    private final Module module;
    private final Set<Instance> instantiating;
    private final Set<Module> instantiatedModules;
    private final boolean isCmm;
    private final boolean isRmm;
    private final boolean isThirdParty;
    @Nullable
    private final Instance parent;
    private final YosysModuleInstantiation instance;
    @Nullable
    private final YosysClockManagementModule clockManagementModule;
    @Nullable
    private final YosysResetManagementModule resetManagementModule;
    private final Set<EntityTreeFile> entityTreeFiles;
    private final Set<ArchitectureTreeFile> architectureTreeFiles;
    private final Set<ComponentInstantiationTreeFile> componentInstantiationTreeFiles;
    private final Set<ComponentTreeFile> componentTreeFiles;
    private final List<ModuleDeclaration> moduleDeclarations;
    private final List<HierarchicalInstance> hierarchicalInstances;
    @Nullable
    private final EntityTreeFile matchingEntity;
    @Nullable
    private final ModuleDeclaration matchingModule;
    private final Set<String> explicitlySetParameters;

    public Instance(YosysModuleInstantiation instance, @Nullable Instance parent, @Nullable YosysClockManagementModule clockManagementModule, @Nullable YosysResetManagementModule resetManagementModule, Set<EntityTreeFile> entityTreeFiles, Set<ArchitectureTreeFile> architectureTreeFiles, Set<ComponentInstantiationTreeFile> componentInstantiationTreeFiles, Set<ComponentTreeFile> componentTreeFiles, List<ModuleDeclaration> moduleDeclarations, List<HierarchicalInstance> hierarchicalInstances, Set<String> explicitlySetParameters, Set<File> filesToAnalyze) {
        this.instance = instance;
        this.parent = parent;
        this.clockManagementModule = clockManagementModule;
        this.resetManagementModule = resetManagementModule;
        this.entityTreeFiles = entityTreeFiles;
        this.architectureTreeFiles = architectureTreeFiles;
        this.componentInstantiationTreeFiles = componentInstantiationTreeFiles;
        this.componentTreeFiles = componentTreeFiles;
        this.moduleDeclarations = moduleDeclarations;
        this.hierarchicalInstances = hierarchicalInstances;
        this.explicitlySetParameters = explicitlySetParameters;
        this.id = this.computeId();
        this.name = this.computeName();
        this.locationAsMarkdown = this.computeLocationAsMarkdown();
        this.doxygenComments = this.computeDoxygenComments();
        this.instantiatedModules = this.computeInstantiatedModules(filesToAnalyze);
        this.instantiating = this.computeInstantiating(filesToAnalyze);
        this.module = this.computeModule(filesToAnalyze);
        this.matchingEntity = this.computeMatchingEntity();
        this.matchingModule = this.computeMatchingModule();
        this.isCmm = this.computeCmm();
        this.isRmm = this.computeRmm();
        this.parameters = this.computeParameters();
        this.isThirdParty = this.instance.module().blackbox() || this.instance.module().location() == null || !FileUtils.contains(filesToAnalyze, this.instance.module().location().file());
    }

    public boolean isTop() {
        return this.parent == null;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public EntityTreeFile matchingEntity() {
        return this.matchingEntity;
    }

    @Nullable
    public ModuleDeclaration matchingModule() {
        return this.matchingModule;
    }

    @Nullable
    public YosysScopes scopes() {
        return this.isTop() ? null : this.instance.cell().scopes();
    }

    public YosysLocation location() {
        return this.instance.cell() != null ? this.instance.cell().location() : this.module.location();
    }

    @Nullable
    public String locationAsMarkdown() {
        return this.locationAsMarkdown;
    }

    public Module module() {
        return this.module;
    }

    public Instance parent() {
        return this.parent;
    }

    public Set<Parameter> parameters() {
        return this.parameters;
    }

    @Nullable
    public String doxygenComments() {
        return this.doxygenComments;
    }

    public Set<Instance> instantiates() {
        return this.instantiating;
    }

    public Set<Instance> instantiatesFromSourceCode() {
        return this.instantiating.stream().filter(i -> !i.isThirdParty()).collect(Collectors.toSet());
    }

    public Set<Module> instantiatedModules() {
        return this.instantiatedModules;
    }

    public Set<Module> instantiatedModulesInSourceCode() {
        return this.instantiatedModules.stream().filter(m -> !m.isThirdParty()).collect(Collectors.toSet());
    }

    public boolean isCmm() {
        return this.isCmm;
    }

    public boolean isRmm() {
        return this.isRmm;
    }

    public boolean isThirdParty() {
        return this.isThirdParty;
    }

    private String computeId() {
        return this.isTop() ? "top" : this.parent.id() + " " + this.instance.cell().name();
    }

    private String computeName() {
        return this.isTop() ? "TOP" : this.instance.cell().name();
    }

    private String computeLocationAsMarkdown() {
        if (this.isTop()) {
            return this.instance.module().location().markdown(this.instance.module().name() + " (top)");
        }
        return this.instance.cell().location().markdown(this.instance.cell().name());
    }

    @Nullable
    private String computeDoxygenComments() {
        String comments = null;
        for (ComponentInstantiationTreeFile componentInstantiation : this.componentInstantiationTreeFiles) {
            if (!componentInstantiation.matchesYosysObject(this.instance)) continue;
            comments = ((ComponentInstantiationStatementTree)componentInstantiation.tree()).doxygenComments();
            return comments;
        }
        for (HierarchicalInstance hierarchicalInstance : this.hierarchicalInstances) {
            if (!hierarchicalInstance.matchesYosysObject(this.instance)) continue;
            comments = hierarchicalInstance.doxygenComments();
            if (comments.isEmpty()) {
                HierarchyInstantiation parent = new HierarchyInstantiation(hierarchicalInstance.parent());
                comments = parent.doxygenComments();
            }
            return comments;
        }
        return comments;
    }

    @Nullable
    private Set<Parameter> computeParameters() {
        HashSet<Parameter> parameters = new HashSet<Parameter>();
        Set<String> notDefaultValueParameters = this.instance.notDefaultValueParameters();
        boolean found = false;
        String componentName = null;
        boolean instantiationByPosition = false;
        for (ComponentInstantiationTreeFile componentInstantiation : this.componentInstantiationTreeFiles) {
            Object object;
            if (!componentInstantiation.matchesYosysObject(this.instance)) continue;
            found = true;
            if (((ComponentInstantiationStatementTree)componentInstantiation.tree()).genericMap() == null || !((object = ((ComponentInstantiationStatementTree)componentInstantiation.tree()).genericMap().associationList()) instanceof AssociationListTree)) continue;
            AssociationListTree l = (AssociationListTree)object;
            for (AssociationElementTree element : l.elements()) {
                if (element.formalPart() != null) {
                    parameters.add(new Parameter(element.formalPart().toString(), new HdlIssueLocation(componentInstantiation.file(), element.formalPart()), element.doxygenComments()));
                    continue;
                }
                instantiationByPosition = true;
                break;
            }
            if (!((ComponentInstantiationStatementTree)componentInstantiation.tree()).instantiatedUnit().is(VhdlTree.Kind.INSTANTIATED_UNIT_COMPONENT)) break;
            componentName = ((ComponentInstantiationStatementTree)componentInstantiation.tree()).instantiatedUnit().name().toString();
            break;
        }
        if (componentName != null && !instantiationByPosition) {
            for (ComponentTreeFile component : this.componentTreeFiles) {
                if (!((ComponentDeclarationTree)component.tree()).identifier().text().equals(componentName)) continue;
                found = true;
                for (InterfaceDeclarationTree generic : ((ComponentDeclarationTree)component.tree()).generics()) {
                    for (IdentifierTree identifier : generic.identifiers()) {
                        Parameter param = parameters.stream().filter(p -> p.name().equalsIgnoreCase(identifier.text())).findFirst().orElse(null);
                        if (param == null) {
                            parameters.add(new Parameter(identifier.text(), new HdlIssueLocation(component.file(), identifier), this.value(identifier.text()), null, false, generic.doxygenComments()));
                            continue;
                        }
                        if (param.comments() != null) continue;
                        param.setComments(generic.doxygenComments());
                    }
                }
            }
        }
        for (EntityTreeFile entityDeclaration : this.entityTreeFiles) {
            if (!entityDeclaration.matchesYosysObject(this.instance.module())) continue;
            found = true;
            for (InterfaceDeclarationTree generic : ((EntityDeclarationTree)entityDeclaration.tree()).generics()) {
                for (IdentifierTree identifier : generic.identifiers()) {
                    Parameter parameter = parameters.stream().filter(p -> p.name().equals(identifier.text())).findFirst().orElse(null);
                    if (parameter != null) {
                        parameter.setValue(this.value(identifier.text()));
                        parameter.setIsDefault(!notDefaultValueParameters.contains(identifier.text().toLowerCase()));
                        if (parameter.comments() != null) continue;
                        parameter.setComments(generic.doxygenComments());
                        continue;
                    }
                    Boolean isSet = this.isTop() ? Boolean.valueOf(this.explicitlySetParameters.contains(identifier.text().toLowerCase())) : (instantiationByPosition ? null : Boolean.valueOf(false));
                    Boolean isDefault = this.isTop() ? (isSet != false ? null : Boolean.valueOf(true)) : (instantiationByPosition ? null : Boolean.valueOf(!notDefaultValueParameters.contains(identifier.text().toLowerCase())));
                    String value = this.isTop() && isDefault != null && isDefault.booleanValue() ? (generic instanceof InterfaceSignalDeclarationTree && ((InterfaceSignalDeclarationTree)generic).defaultValue() != null ? ((InterfaceSignalDeclarationTree)generic).defaultValue().toStringWithWhitespaceBetweenEachTree() : "") : this.value(identifier.text());
                    parameters.add(new Parameter(identifier.text(), new HdlIssueLocation(entityDeclaration.file(), identifier), value, isDefault, isSet, generic.doxygenComments()));
                }
            }
        }
        if (!found) {
            return null;
        }
        return parameters;
    }

    @Nullable
    private String value(String text) {
        return this.instance.parameters().stream().filter(p -> text.equalsIgnoreCase(p.key())).map(YosysModuleInstantiationParameter::value).findFirst().orElse(null);
    }

    private Set<Module> computeInstantiatedModules(Set<File> filesToAnalyze) {
        HashSet<Module> modules = new HashSet<Module>();
        for (YosysModuleInstantiation child : this.instance.children()) {
            modules.add(new Module(child.module(), this.entityTreeFiles, this.architectureTreeFiles, filesToAnalyze));
        }
        return modules;
    }

    @Nullable
    private EntityTreeFile computeMatchingEntity() {
        EntityTreeFile matchingEntity = null;
        for (EntityTreeFile tf : this.entityTreeFiles) {
            if (!tf.matchesYosysObject(this.instance.module())) continue;
            matchingEntity = tf;
            break;
        }
        return matchingEntity;
    }

    @Nullable
    private ModuleDeclaration computeMatchingModule() {
        ModuleDeclaration matchingModule = null;
        for (ModuleDeclaration md : this.moduleDeclarations) {
            if (!this.moduleDeclarationMatchingYosysObject(md, this.instance.module())) continue;
            matchingModule = md;
            break;
        }
        return matchingModule;
    }

    private boolean moduleDeclarationMatchingYosysObject(ModuleDeclaration moduleDeclaration, YosysModule yosysModule) {
        return yosysModule.location() != null && moduleDeclaration.identifier().text().equals(yosysModule.name()) && FileUtils.equals(moduleDeclaration.location().file(), yosysModule.location().file()) && moduleDeclaration.identifier().location().line() == yosysModule.location().beginLine() && moduleDeclaration.identifier().location().column() == yosysModule.location().beginColumn();
    }

    private Module computeModule(Set<File> filesToAnalyze) {
        return new Module(this.instance.module(), this.entityTreeFiles, this.architectureTreeFiles, filesToAnalyze);
    }

    private Set<Instance> computeInstantiating(Set<File> filesToAnalyze) {
        return this.instance.children().stream().map(c -> new Instance((YosysModuleInstantiation)c, this, this.clockManagementModule, this.resetManagementModule, this.entityTreeFiles, this.architectureTreeFiles, this.componentInstantiationTreeFiles, this.componentTreeFiles, this.moduleDeclarations, this.hierarchicalInstances, this.explicitlySetParameters, filesToAnalyze)).collect(Collectors.toSet());
    }

    private boolean computeCmm() {
        return !this.isTop() && this.clockManagementModule != null && this.name.equals(this.clockManagementModule.instanceName()) && this.location().equals(this.clockManagementModule.instanceLocation());
    }

    private boolean computeRmm() {
        return !this.isTop() && this.resetManagementModule != null && this.name.equals(this.resetManagementModule.instanceName()) && this.location().equals(this.resetManagementModule.instanceLocation());
    }
}

