/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.designhierarchy.graph;

import com.lintyservices.sonar.plugins.hdl.GraphUtils;
import com.lintyservices.sonar.plugins.hdl.designhierarchy.Module;
import javax.annotation.Nullable;

public class ModuleForGraph {
    private final String name;
    private final String library;
    private final boolean blackbox;
    @Nullable
    private final String location;
    @Nullable
    private final String architectureName;
    @Nullable
    private final String architectureLocation;
    @Nullable
    private final String comments;
    private final boolean thirdParty;

    public ModuleForGraph(Module module) {
        this.name = module.name();
        this.library = module.library();
        this.blackbox = module.blackbox();
        this.location = module.location() != null ? GraphUtils.url(module.location()) : null;
        this.architectureLocation = module.architectureLocation() != null ? GraphUtils.url(module.architectureLocation()) : null;
        this.architectureName = module.architectureName();
        this.thirdParty = module.isThirdParty();
        String comments = module.doxygenComments();
        this.comments = comments != null ? GraphUtils.removeHtmlTags(comments) : null;
    }
}

