/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.graph.logiccircuit;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lintyservices.sonar.plugins.hdl.graph.logiccircuit.LogicCircuitGraph;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class CDCLogicCircuitGraph
extends LogicCircuitGraph {
    public CDCLogicCircuitGraph(File jsonFile, String graphTitle) {
        super("cdc_logic_circuit", graphTitle);
        JsonObject jsonObject = CDCLogicCircuitGraph.readJsonFile(jsonFile);
        CDCLogicCircuitGraph.cleanClockDomains(jsonObject);
        HashSet<String> clockDomains = new HashSet<String>();
        CDCLogicCircuitGraph.extractClockDomains(jsonObject, clockDomains);
        Set sanitizedClockDomains = clockDomains.stream().map(d -> Arrays.stream(d.split("\\|")).toList()).flatMap(Collection::stream).collect(Collectors.toSet());
        JsonArray jsonArray = new JsonArray();
        for (String domain : new HashSet(sanitizedClockDomains)) {
            jsonArray.add(domain);
        }
        jsonObject.add("clock_domains", jsonArray);
        this.setData(CDCLogicCircuitGraph.updateSrcValues(jsonObject));
    }

    private static void cleanClockDomains(JsonElement element) {
        block4: {
            block3: {
                JsonObject jsonObject;
                Object attributes;
                if (!element.isJsonObject()) break block3;
                JsonObject obj = element.getAsJsonObject();
                if (obj.has("attributes") && ((JsonElement)(attributes = obj.get("attributes"))).isJsonObject() && (jsonObject = ((JsonElement)attributes).getAsJsonObject()).has("clock_domain")) {
                    String currentValue = jsonObject.get("clock_domain").getAsString();
                    jsonObject.addProperty("clock_domain", currentValue.replace("\\", ""));
                }
                for (Map.Entry entry : obj.entrySet()) {
                    CDCLogicCircuitGraph.cleanClockDomains((JsonElement)entry.getValue());
                }
                break block4;
            }
            if (!element.isJsonArray()) break block4;
            for (JsonElement arrayElement : element.getAsJsonArray()) {
                CDCLogicCircuitGraph.cleanClockDomains(arrayElement);
            }
        }
    }

    private static void extractClockDomains(@Nullable JsonElement element, Set<String> values) {
        block10: {
            block9: {
                if (element == null || element.isJsonNull()) {
                    return;
                }
                if (!element.isJsonObject()) break block9;
                JsonObject jsonObject = element.getAsJsonObject();
                for (String key : jsonObject.keySet()) {
                    if (key.equals("attributes")) {
                        JsonElement value = jsonObject.get(key);
                        if (value.isJsonObject()) {
                            JsonElement propValue;
                            JsonObject childObject = value.getAsJsonObject();
                            if (childObject.has("clock_domain") && (propValue = childObject.get("clock_domain")).isJsonPrimitive() && propValue.getAsJsonPrimitive().isString()) {
                                values.add(propValue.getAsString());
                            }
                        } else if (value.isJsonArray()) {
                            JsonArray array = value.getAsJsonArray();
                            for (JsonElement arrayElement : array) {
                                JsonElement propValue;
                                JsonObject arrayObject;
                                if (!arrayElement.isJsonObject() || !(arrayObject = arrayElement.getAsJsonObject()).has("clock_domain") || !(propValue = arrayObject.get("clock_domain")).isJsonPrimitive() || !propValue.getAsJsonPrimitive().isString()) continue;
                                values.add(propValue.getAsString());
                            }
                        }
                    }
                    CDCLogicCircuitGraph.extractClockDomains(jsonObject.get(key), values);
                }
                break block10;
            }
            if (!element.isJsonArray()) break block10;
            JsonArray jsonArray = element.getAsJsonArray();
            for (JsonElement arrayElement : jsonArray) {
                CDCLogicCircuitGraph.extractClockDomains(arrayElement, values);
            }
        }
    }
}

