/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.graph.logiccircuit;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lintyservices.sonar.plugins.hdl.Graph;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class LogicCircuitGraph
extends Graph {
    private JsonElement data;

    public LogicCircuitGraph(String graphType, String graphTitle) {
        super(graphType, graphTitle);
        this.data = null;
    }

    public LogicCircuitGraph(JsonObject jsonObject, String graphTitle) {
        super("logic_circuit", graphTitle);
        this.data = LogicCircuitGraph.updateSrcValues(jsonObject);
    }

    public LogicCircuitGraph(File jsonFile, String graphType, String graphTitle) {
        super(graphType, graphTitle);
        JsonObject jsonElement = LogicCircuitGraph.readJsonFile(jsonFile);
        this.data = LogicCircuitGraph.updateSrcValues(jsonElement);
    }

    protected static JsonObject readJsonFile(File jsonFile) {
        JsonObject jsonObject;
        Gson gson = new Gson();
        try (FileReader reader = new FileReader(jsonFile);){
            jsonObject = gson.fromJson((Reader)reader, JsonObject.class);
        }
        catch (IOException e) {
            throw new LintyException("Cannot load JSON from: " + FileUtils.sanitizedPath(jsonFile.getAbsolutePath()), e);
        }
        return jsonObject;
    }

    protected static JsonElement updateSrcValues(JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            JsonObject newObj = new JsonObject();
            for (String key : obj.keySet()) {
                JsonElement value = obj.get(key);
                if (key.equals("src") && value.isJsonPrimitive() && value.getAsJsonPrimitive().isString()) {
                    newObj.addProperty(key, LogicCircuitGraph.convertFromYosysToLintyLocation(value.getAsString()));
                    continue;
                }
                newObj.add(key, LogicCircuitGraph.updateSrcValues(value));
            }
            return newObj;
        }
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            JsonArray newArray = new JsonArray();
            for (JsonElement item : array) {
                newArray.add(LogicCircuitGraph.updateSrcValues(item));
            }
            return newArray;
        }
        return element;
    }

    public void setData(JsonElement data) {
        this.data = data;
    }

    @VisibleForTesting
    public JsonElement data() {
        return this.data;
    }

    private static String convertFromYosysToLintyLocation(String location) {
        Object path = location.substring(0, location.indexOf(58));
        path = ((String)path).startsWith(".") ? ((String)path).substring(1) : "/" + (String)path;
        String afterFilePath = location.substring(location.indexOf(58) + 1);
        String line = afterFilePath.substring(0, afterFilePath.indexOf(46));
        return (String)path + "#" + line;
    }
}

