/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.logiccircuit;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.interfaces.YosysResetClockDomainOrigin;
import com.lintyservices.yosys.objects.YosysClockOrResetDomain;
import com.lintyservices.yosys.objects.YosysLocation;
import com.lintyservices.yosys.objects.YosysResetClockDomainOriginAsFlipFlop;
import com.lintyservices.yosys.objects.YosysResetClockDomainOriginAsPort;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;

public class ClockAndResetDomainUtils {
    private final Set<File> filesToAnalyze;
    private final HdlIssueLocation topModuleLocation;
    private final File projectBaseDir;

    public ClockAndResetDomainUtils(Set<File> filesToAnalyze, HdlIssueLocation topModuleLocation, Configuration config) {
        this.filesToAnalyze = filesToAnalyze;
        this.topModuleLocation = topModuleLocation;
        this.projectBaseDir = new File((String)config.get("sonar.projectBaseDir").get());
    }

    public List<HdlIssueLocation> originLocations(YosysClockOrResetDomain clockOrResetDomain) {
        return this.flow(clockOrResetDomain.origins(), this.fallbackOriginLocation(clockOrResetDomain.location()));
    }

    public Map<String, HdlIssueLocation> originLocationsAsMap(YosysClockOrResetDomain clockOrResetDomain) {
        return this.flowAsMap(clockOrResetDomain.origins(), this.fallbackOriginLocation(clockOrResetDomain.location()));
    }

    public HdlIssueLocation mainLocation(YosysClockOrResetDomain domain) {
        if (domain.origins().size() > 1 && domain.location() != null) {
            return new HdlIssueLocation(domain.location());
        }
        return this.originLocations(domain).get(0);
    }

    public List<HdlIssueLocation> secondaryLocations(YosysClockOrResetDomain domain) {
        List<HdlIssueLocation> locations = this.originLocations(domain);
        if (locations.size() <= 1) {
            return new ArrayList<HdlIssueLocation>();
        }
        if (domain.location() != null) {
            return locations;
        }
        return locations.subList(1, locations.size());
    }

    private List<HdlIssueLocation> flow(List<YosysResetClockDomainOrigin> origins, HdlIssueLocation fallbackLocation) {
        HashSet<HdlIssueLocation> flow = new HashSet<HdlIssueLocation>();
        for (YosysResetClockDomainOrigin origin : origins) {
            if (origin instanceof YosysResetClockDomainOriginAsPort) {
                YosysResetClockDomainOriginAsPort p = (YosysResetClockDomainOriginAsPort)origin;
                flow.add(this.sanitizedIssueLocation(p.port().location(), fallbackLocation, String.format("%s origin: %s", p.port().fromBlackbox() ? "Blackbox port" : "Port", p.port().name())));
                continue;
            }
            if (!(origin instanceof YosysResetClockDomainOriginAsFlipFlop)) continue;
            YosysResetClockDomainOriginAsFlipFlop f = (YosysResetClockDomainOriginAsFlipFlop)origin;
            flow.add(this.sanitizedIssueLocation(f.flipFlop().location(), fallbackLocation, "Flip-flop origin"));
        }
        return flow.stream().sorted().toList();
    }

    private Map<String, HdlIssueLocation> flowAsMap(List<YosysResetClockDomainOrigin> origins, HdlIssueLocation fallbackLocation) {
        HashMap<String, HdlIssueLocation> flow = new HashMap<String, HdlIssueLocation>();
        for (YosysResetClockDomainOrigin origin : origins) {
            if (origin instanceof YosysResetClockDomainOriginAsPort) {
                YosysResetClockDomainOriginAsPort p = (YosysResetClockDomainOriginAsPort)origin;
                flow.put(p.port().name(), this.sanitizedIssueLocation(p.port().location(), fallbackLocation, String.format("%s origin: %s", p.port().fromBlackbox() ? "Blackbox port" : "Port", p.port().name())));
                continue;
            }
            if (!(origin instanceof YosysResetClockDomainOriginAsFlipFlop)) continue;
            YosysResetClockDomainOriginAsFlipFlop f = (YosysResetClockDomainOriginAsFlipFlop)origin;
            for (String name : f.flipFlop().qPublicNames()) {
                flow.put(name, this.sanitizedIssueLocation(f.flipFlop().location(), fallbackLocation, "Flip-flop origin"));
            }
        }
        return flow;
    }

    private HdlIssueLocation sanitizedIssueLocation(@Nullable YosysLocation location, HdlIssueLocation fallbackLocation, String message) {
        if (location != null && location.file() != null) {
            if (FileUtils.contains(this.filesToAnalyze, location.file())) {
                return new HdlIssueLocation(location, message);
            }
            return new HdlIssueLocation(location, String.format("%s. Not in analyzed source code: %s", message, location.text()));
        }
        return new HdlIssueLocation(fallbackLocation, String.format("%s. %s", message, fallbackLocation.message()));
    }

    private HdlIssueLocation fallbackOriginLocation(@Nullable YosysLocation location) {
        if (location != null && location.file() != null) {
            if (FileUtils.contains(this.filesToAnalyze, location.file())) {
                return new HdlIssueLocation(location);
            }
            return new HdlIssueLocation(this.topModuleLocation, String.format("Not analyzed source code: %s#%s.", this.projectBaseDir.toPath().relativize(location.file().toPath()), location.beginLine()));
        }
        return new HdlIssueLocation(this.topModuleLocation, "Unknown location.");
    }
}

