/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.logiccircuit;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.slang.trees.GenericAlwaysBlock;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.IssueLocation;
import com.lintyservices.sonar.plugins.vhdl.api.VhdlFileTreeTuple;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlSyntaxToken;
import com.lintyservices.sonar.plugins.vhdl.api.tree.VhdlTree;
import com.lintyservices.sonar.plugins.vhdl.parser.DesignFileTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IfElsifConditionTree;
import com.lintyservices.sonar.plugins.vhdl.parser.IfStatementTree;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import com.lintyservices.yosys.objects.YosysClockDomainUsage;
import com.lintyservices.yosys.objects.YosysFlipFlop;
import com.lintyservices.yosys.objects.YosysLocation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;

public class DCUtils {
    private final Set<File> filesToAnalyze;
    @Nullable
    private final List<VhdlFileTreeTuple> vhdlFileTreeTuples;
    @Nullable
    private final List<GenericAlwaysBlock> alwaysBlocks;
    private final HdlIssueLocation topModuleLocation;
    private final Configuration config;

    public DCUtils(Set<File> filesToAnalyze, @Nullable List<VhdlFileTreeTuple> vhdlFileTreeTuples, @Nullable List<GenericAlwaysBlock> alwaysBlocks, HdlIssueLocation topModuleLocation, Configuration config) {
        this.filesToAnalyze = filesToAnalyze;
        this.vhdlFileTreeTuples = vhdlFileTreeTuples;
        this.alwaysBlocks = alwaysBlocks;
        this.topModuleLocation = topModuleLocation;
        this.config = config;
    }

    public HdlIssueLocation flipFlopToIssueLocation(YosysLocation location, String source2) {
        if (!FileUtils.contains(this.filesToAnalyze, location.file())) {
            return new HdlIssueLocation(this.topModuleLocation, String.format("%s not in analyzed source code: %s", source2, location.text()));
        }
        String message = source2 + " flip-flop";
        if (this.vhdlFileTreeTuples != null && FileUtils.contains(this.vhdlFileTreeTuples.stream().map(VhdlFileTreeTuple::file).collect(Collectors.toSet()), location.file())) {
            DesignFileTree tree = this.vhdlFileTreeTuples.stream().filter(f -> FileUtils.equals(location.file(), f.file())).findFirst().get().tree();
            IfStatementTree ifStatementTree = this.flipFlopIfStatement(tree, location.beginLine(), location.beginColumn());
            if (ifStatementTree != null) {
                IfElsifConditionTree ifElsifConditionTree = this.ifElsifConditionTree(ifStatementTree);
                VhdlTree issueTree = ifElsifConditionTree != null ? ifElsifConditionTree : ifStatementTree.ifKeyword();
                return new HdlIssueLocation(location.file(), issueTree, message);
            }
            return new HdlIssueLocation(new YosysLocation(location.file(), location.beginLine(), location.beginColumn(), location.beginLine(), location.beginColumn() + 2), message);
        }
        GenericAlwaysBlock alwaysBlock = this.alwaysBlock(location);
        if (alwaysBlock != null) {
            return new HdlIssueLocation(alwaysBlock.keyword().location(), message);
        }
        return new HdlIssueLocation(location.file(), location.beginLine(), message);
    }

    public List<HdlIssueLocation> signalsToIssueLocations(YosysFlipFlop flipFlop) {
        File file = flipFlop.location().file();
        if (flipFlop.location() == null || flipFlop.location().file() == null || !FileUtils.contains(this.filesToAnalyze, file)) {
            return new ArrayList<HdlIssueLocation>();
        }
        ArrayList<HdlIssueLocation> locations = new ArrayList<HdlIssueLocation>();
        if (this.vhdlFileTreeTuples != null && FileUtils.contains(this.vhdlFileTreeTuples.stream().map(VhdlFileTreeTuple::file).collect(Collectors.toSet()), file)) {
            DesignFileTree tree = this.vhdlFileTreeTuples.stream().filter(f -> FileUtils.equals(file, f.file())).findFirst().get().tree();
            IfStatementTree ifStatementTree = this.flipFlopIfStatement(tree, flipFlop.location().beginLine(), flipFlop.location().beginColumn());
            if (ifStatementTree != null) {
                Set qPublicNames = flipFlop.qPublicNames().stream().map(this::shortName).collect(Collectors.toSet());
                List<VhdlSyntaxToken> tokens = ifStatementTree.allChildren(VhdlTree.Kind.TOKEN).stream().map(t -> (VhdlSyntaxToken)t).toList();
                for (VhdlSyntaxToken token : tokens) {
                    if (!qPublicNames.contains(token.text().toLowerCase())) continue;
                    locations.add(new HdlIssueLocation(file, token, token.text()));
                }
            }
        } else {
            GenericAlwaysBlock alwaysBlock = this.alwaysBlock(flipFlop.location());
            if (alwaysBlock != null) {
                Set qPublicNames = flipFlop.qPublicNames().stream().map(this::shortName).collect(Collectors.toSet());
                for (SyntaxNode token : alwaysBlock.node().getAllTokens()) {
                    if (!qPublicNames.contains(token.text())) continue;
                    locations.add(new HdlIssueLocation(token.location(), token.text()));
                }
            }
        }
        for (String qPublicName : flipFlop.qPublicNames()) {
            locations.addAll(this.readLines(flipFlop.location(), this.shortName(qPublicName)));
        }
        return this.reverseSort(new HashSet(locations).stream().toList());
    }

    public HdlIssueLocation clockDomainUsageToIssueLocation(YosysClockDomainUsage clockDomainUsage, String source2) {
        if (FileUtils.contains(this.filesToAnalyze, clockDomainUsage.clockDomain().location().file())) {
            return new HdlIssueLocation(clockDomainUsage.clockDomain().location(), String.format("%s clock domain: %s (%s)", source2, clockDomainUsage.clockDomain().name(), clockDomainUsage.direction().value()));
        }
        return new HdlIssueLocation(this.topModuleLocation, String.format("%s clock domain: %s (%s). Clock signal not in analyzed source code: %s", source2, clockDomainUsage.clockDomain().name(), clockDomainUsage.direction().value(), clockDomainUsage.clockDomain().location().text()));
    }

    public String signalsToMarkdown(YosysFlipFlop flipFlop) {
        return this.signalsToIssueLocations(flipFlop).stream().map(location -> location.markdown(this.config)).collect(Collectors.toSet()).stream().sorted().collect(Collectors.joining("<br>- "));
    }

    public Set<File> filesToAnalyze() {
        return this.filesToAnalyze;
    }

    @Nullable
    private IfStatementTree flipFlopIfStatement(DesignFileTree tree, int verificLine, int verificColumn) {
        return tree.allChildren(VhdlTree.Kind.IF_STATEMENT).stream().filter(t -> t.line() == verificLine && t.column() + 1 == verificColumn).map(t -> (IfStatementTree)t).findFirst().orElse(null);
    }

    @Nullable
    private IfElsifConditionTree ifElsifConditionTree(IfStatementTree ifStatementTree) {
        for (IfElsifConditionTree ifElsifConditionTree : ifStatementTree.allChildren(VhdlTree.Kind.IF_ELSIF_CONDITION).stream().map(t -> (IfElsifConditionTree)t).toList()) {
            String condition = ifElsifConditionTree.toString().replaceAll("\\s+", "").toLowerCase();
            Set<String> clockUsagePatterns = Set.of("rising_edge(", "falling_edge(", "'event", "'stable");
            for (String clockUsagePattern : clockUsagePatterns) {
                if (!condition.contains(clockUsagePattern)) continue;
                return ifElsifConditionTree;
            }
        }
        return null;
    }

    @Nullable
    private GenericAlwaysBlock alwaysBlock(YosysLocation location) {
        return this.alwaysBlocks.stream().filter(b -> b.location() != null).filter(b -> b.location().line() <= location.beginLine() && b.location().endLine() >= location.endLine()).findFirst().orElse(null);
    }

    private String shortName(String name) {
        String[] shortNames = name.toLowerCase().split("\\.");
        return shortNames[shortNames.length - 1].split("\\[")[0];
    }

    private List<HdlIssueLocation> readLines(YosysLocation location, String pattern) {
        ArrayList<HdlIssueLocation> locations = new ArrayList<HdlIssueLocation>();
        for (int line = location.beginLine(); line <= location.endLine(); ++line) {
            try {
                String currentLine = Files.readAllLines(location.file().toPath()).get(line);
                int index = currentLine.indexOf(pattern.toLowerCase());
                while (index >= 0) {
                    locations.add(new HdlIssueLocation(new YosysLocation(location.file(), line + 1, index + 1, line + 1, index + pattern.length() + 1), pattern));
                    index = currentLine.indexOf(pattern.toLowerCase(), index + 1);
                }
                continue;
            }
            catch (IOException e) {
                throw new LintyException("Cannot read file: " + String.valueOf(location.file().getAbsoluteFile()), e);
            }
        }
        return locations;
    }

    private List<HdlIssueLocation> reverseSort(List<HdlIssueLocation> locations) {
        return locations.stream().sorted(IssueLocation::compareTo).toList();
    }
}

