/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.measures;

import com.lintyservices.sonar.plugins.bugfinder.visitors.BugFinderCustomMetricsAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.measures.YosysMetrics;
import com.lintyservices.yosys.objects.YosysCustomMetrics;
import java.io.Serializable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.measures.Metric;

public class YosysMetricsImporter
implements BugFinderCustomMetricsAwareVisitor {
    private final SensorContext context;
    private YosysCustomMetrics metrics;

    @Override
    public void setCustomMetrics(YosysCustomMetrics metrics) {
        this.metrics = metrics;
    }

    public YosysMetricsImporter(SensorContext context) {
        this.context = context;
    }

    public void saveMetrics() {
        this.saveMetric(this.context, YosysMetrics.PUBLIC_WIRES, this.metrics.publicWires());
        this.saveMetric(this.context, YosysMetrics.PUBLIC_WIRE_BITS, this.metrics.publicWireBits());
        this.saveMetric(this.context, YosysMetrics.WIRES, this.metrics.wires());
        this.saveMetric(this.context, YosysMetrics.WIRE_BITS, this.metrics.wireBits());
        this.saveMetric(this.context, YosysMetrics.MEMORIES, this.metrics.memories());
        this.saveMetric(this.context, YosysMetrics.MEMORY_BITS, this.metrics.memoryBits());
        this.saveMetric(this.context, YosysMetrics.CELLS, this.metrics.cells());
        this.saveMetric(this.context, YosysMetrics.FLIP_FLOP_CELLS, this.metrics.flipFlopCells());
        this.saveMetric(this.context, YosysMetrics.NON_FLIP_FLOP_CELLS, this.metrics.nonFlipFlopCells());
    }

    private <T extends Serializable> void saveMetric(SensorContext sensorContext, Metric<T> metric, T value) {
        sensorContext.newMeasure().forMetric(metric).on((InputComponent)sensorContext.project()).withValue(value).save();
    }
}

