/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.reset;

import com.lintyservices.sonar.plugins.bugfinder.objects.resetdomain.RDCsInterface;
import com.lintyservices.sonar.plugins.hdl.logiccircuit.ClockAndResetDomainUtils;
import com.lintyservices.sonar.plugins.hdl.logiccircuit.DCUtils;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.yosys.objects.YosysRDC;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RDCs
implements RDCsInterface {
    private final List<YosysRDC> rdcs;
    private final DCUtils dcUtils;
    private final ClockAndResetDomainUtils clockAndResetDomainUtils;

    public RDCs(Set<YosysRDC> allRdcs, DCUtils dcUtils, ClockAndResetDomainUtils clockAndResetDomainUtils) {
        this.dcUtils = dcUtils;
        this.clockAndResetDomainUtils = clockAndResetDomainUtils;
        this.rdcs = this.filterRDCs(allRdcs);
    }

    public List<YosysRDC> asList() {
        return this.rdcs;
    }

    public Map<String, List<YosysRDC>> asMap() {
        HashMap<String, List<YosysRDC>> map = new HashMap<String, List<YosysRDC>>();
        for (YosysRDC rdc : this.rdcs) {
            String key = rdc.fullOriginClockDomain() + ";" + rdc.fullTargetClockDomain();
            if (map.containsKey(key)) {
                ((List)map.get(key)).add(rdc);
                continue;
            }
            ArrayList<YosysRDC> rdcList = new ArrayList<YosysRDC>();
            rdcList.add(rdc);
            map.put(key, rdcList);
        }
        return map;
    }

    public int size() {
        return this.rdcs.size();
    }

    public DCUtils dcUtils() {
        return this.dcUtils;
    }

    public ClockAndResetDomainUtils clockAndResetDomainUtils() {
        return this.clockAndResetDomainUtils;
    }

    private List<YosysRDC> filterRDCs(Set<YosysRDC> allRDCs) {
        return allRDCs.stream().filter(c -> FileUtils.contains(this.dcUtils.filesToAnalyze(), c.target().location().file())).sorted(Comparator.comparingInt(YosysRDC::id)).toList();
    }
}

