/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.hdl.visitors;

import com.lintyservices.sonar.plugins.linty.language.trees.Tree;
import io.github.azagniotov.matcher.AntPathMatcher;
import java.io.File;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;

public record FileScannerContext<T extends Tree>(T tree, File file, Configuration configuration) {
    public boolean isSimulationFile() {
        String projectBaseDir = this.configuration.get("sonar.projectBaseDir").orElse("");
        String fileRelativePath = this.file().getAbsolutePath();
        if (!projectBaseDir.isEmpty()) {
            fileRelativePath = fileRelativePath.substring(projectBaseDir.length() + 1);
        }
        for (String pattern : this.configuration.getStringArray("sonar.hdl.file.simulationPaths")) {
            AntPathMatcher pathMatcher = new AntPathMatcher.Builder().build();
            if (!pathMatcher.isMatch(pattern, fileRelativePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isSynthesisFile() {
        return !this.isSimulationFile();
    }

    @Nullable
    public String topLevelModule() {
        return this.configuration.get("sonar.hdl.topModule").orElse(null);
    }
}

