/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.linty.language.checks;

import com.google.common.base.Preconditions;
import com.lintyservices.sonar.plugins.linty.language.checks.Check;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.scanner.ScannerSide;

@ScannerSide
public interface CheckRegistrar {
    public void register(RegistrarContext var1);

    public static class RegistrarContext {
        private String repositoryKey;
        private Iterable<Class<Check>> checkClasses;
        private Iterable<Class<Check>> testCheckClasses;

        public void registerClassesForRepository(String repositoryKey, Iterable<Class<Check>> checkClasses, Iterable<Class<Check>> testCheckClasses) {
            Preconditions.checkArgument(StringUtils.isNotBlank(repositoryKey), "Please specify a valid repository key to register your custom rules");
            this.repositoryKey = repositoryKey;
            this.checkClasses = checkClasses;
            this.testCheckClasses = testCheckClasses;
        }

        public String repositoryKey() {
            return this.repositoryKey;
        }

        public Iterable<Class<Check>> checkClasses() {
            return this.checkClasses;
        }

        public Iterable<Class<Check>> testCheckClasses() {
            return this.testCheckClasses;
        }
    }
}

