/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.linty.language.issues;

import com.google.common.base.Preconditions;
import com.lintyservices.sonar.plugins.linty.language.checks.Check;
import com.lintyservices.sonar.plugins.linty.language.checks.Checks;
import com.lintyservices.sonar.plugins.linty.language.issues.FileIssue;
import com.lintyservices.sonar.plugins.linty.language.issues.IssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.LineIssue;
import com.lintyservices.sonar.plugins.linty.language.issues.LineIssueWithFlows;
import com.lintyservices.sonar.plugins.linty.language.issues.PreciseIssue;
import com.lintyservices.sonar.plugins.linty.language.issues.PreciseIssueWithFlows;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueInterface;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import com.lintyservices.utils.FileUtils;
import com.lintyservices.utils.LintyException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;

public class IssueSaver {
    private final SensorContext sensorContext;
    private final Checks checks;
    private final FileSystem fileSystem;
    private final Set<File> filesToAnalyze;
    private final File projectBaseDir;
    private final FilePredicate filesPredicate;
    private final boolean hdlDesigner;
    public static final Logger LOG = LoggerFactory.getLogger(IssueSaver.class);

    public IssueSaver(SensorContext sensorContext, Checks checks, Set<File> filesToAnalyze, FilePredicate filesPredicate, boolean hdlDesigner) {
        this.sensorContext = sensorContext;
        this.fileSystem = sensorContext.fileSystem();
        this.filesToAnalyze = filesToAnalyze;
        this.projectBaseDir = new File(sensorContext.config().get("sonar.projectBaseDir").orElse(""));
        this.checks = checks;
        this.filesPredicate = filesPredicate;
        this.hdlDesigner = hdlDesigner;
    }

    public void saveIssue(IssueInterface issue) {
        LOG.debug("Saving issue:\n");
        LOG.debug(issue.toString());
        if (issue instanceof FileIssue) {
            FileIssue i = (FileIssue)issue;
            this.saveFileIssue(i);
        } else if (issue instanceof LineIssue) {
            LineIssue i = (LineIssue)issue;
            this.saveLineIssue(i);
        } else if (issue instanceof PreciseIssue) {
            PreciseIssue i = (PreciseIssue)issue;
            this.savePreciseIssue(i);
        } else if (issue instanceof PreciseIssueWithFlows) {
            PreciseIssueWithFlows i = (PreciseIssueWithFlows)issue;
            this.savePreciseIssueWithFlows(i);
        } else if (issue instanceof LineIssueWithFlows) {
            LineIssueWithFlows i = (LineIssueWithFlows)issue;
            this.saveLineIssueWithFlows(i);
        } else {
            throw new LintyException("[IssueSaver.saveIssue] Unknown issue type: " + String.valueOf(issue.getClass()));
        }
        LOG.debug("Saving issue: Done\n");
    }

    public void saveIssues(List<IssueInterface> issues) {
        for (IssueInterface issue : issues) {
            this.saveIssue(issue);
        }
    }

    private void savePreciseIssue(PreciseIssue issue) {
        NewIssue newIssue = this.sensorContext.newIssue();
        InputFile primaryFile = this.getInputFile(issue.primaryLocation().file());
        if (primaryFile == null) {
            this.cannotSaveIssue(issue);
            return;
        }
        newIssue.forRule(this.ruleKey(issue.check())).at(this.newLocation(primaryFile, newIssue, issue.primaryLocation()));
        if (issue.cost() != null) {
            newIssue.gap(issue.cost());
        }
        for (IssueLocationInterface issueLocationInterface : issue.secondaryLocations()) {
            InputFile secondaryFile = issueLocationInterface.file() != null ? this.getInputFile(issueLocationInterface.file()) : primaryFile;
            if (secondaryFile == null) continue;
            newIssue.addLocation(this.newLocation(secondaryFile, newIssue, issueLocationInterface));
        }
        newIssue.save();
    }

    private void savePreciseIssueWithFlows(PreciseIssueWithFlows issue) {
        NewIssue newIssue = this.sensorContext.newIssue();
        InputFile primaryFile = this.getInputFile(issue.primaryLocation().file());
        if (primaryFile == null) {
            this.cannotSaveIssue(issue);
            return;
        }
        NewIssueLocation primaryLocation = issue.primaryLocation().isLineLocation() ? newIssue.newLocation().message(issue.primaryLocation().message()).on((InputComponent)primaryFile).at(primaryFile.selectLine(issue.primaryLocation().startLine())) : this.newLocation(primaryFile, newIssue, issue.primaryLocation());
        newIssue.forRule(this.ruleKey(issue.check())).at(primaryLocation);
        if (issue.cost() != null) {
            newIssue.gap(issue.cost());
        }
        for (List<? extends IssueLocationInterface> flow : issue.flows()) {
            ArrayList<NewIssueLocation> updatedFlow = new ArrayList<NewIssueLocation>();
            for (IssueLocationInterface issueLocationInterface : flow) {
                if (FileUtils.contains(this.filesToAnalyze, issueLocationInterface.file())) {
                    InputFile issueFile = this.fileSystem.inputFile(this.fileSystem.predicates().is(issueLocationInterface.file()));
                    updatedFlow.add(this.newLocation(issueFile, newIssue, issueLocationInterface));
                    continue;
                }
                updatedFlow.add(this.newLocation(primaryFile, newIssue, new IssueLocation(issue.primaryLocation().file(), issue.primaryLocation().startLine(), issue.primaryLocation().startColumn(), issue.primaryLocation().endLine(), issue.primaryLocation().endColumn(), String.format("%s. Issue location in a file not analyzed by Linty: %s, line %s", issueLocationInterface.message(), this.getRelativePathToProjectBaseDir(issueLocationInterface.file()), issueLocationInterface.startLine()))));
            }
            updatedFlow.add(primaryLocation);
            newIssue.addFlow(updatedFlow);
        }
        newIssue.save();
    }

    private void saveFileIssue(FileIssue issue) {
        NewIssue newIssue = this.sensorContext.newIssue();
        InputFile primaryFile = this.getInputFile(issue.file());
        if (primaryFile == null) {
            this.cannotSaveIssue(issue);
            return;
        }
        NewIssueLocation primaryLocation = newIssue.newLocation().message(issue.message()).on((InputComponent)primaryFile);
        newIssue.forRule(this.ruleKey(issue.check())).at(primaryLocation);
        if (issue.cost() != null) {
            newIssue.gap(issue.cost());
        }
        for (IssueLocation secondary : issue.secondaryLocations()) {
            InputFile secondaryFile = this.fileSystem.inputFile(this.fileSystem.predicates().is(secondary.file()));
            if (secondaryFile == null) {
                secondaryFile = primaryFile;
            }
            newIssue.addLocation(this.newLocation(secondaryFile, newIssue, secondary));
        }
        newIssue.save();
    }

    private void saveLineIssue(LineIssue issue) {
        NewIssue newIssue = this.sensorContext.newIssue();
        InputFile primaryFile = this.getInputFile(issue.file());
        if (primaryFile == null) {
            this.cannotSaveIssue(issue);
            return;
        }
        NewIssueLocation primaryLocation = newIssue.newLocation().message(issue.message()).on((InputComponent)primaryFile).at(primaryFile.selectLine(issue.line()));
        newIssue.forRule(this.ruleKey(issue.check())).at(primaryLocation);
        if (issue.cost() != null) {
            newIssue.gap(issue.cost());
        }
        for (IssueLocationInterface issueLocationInterface : issue.secondaryLocations()) {
            InputFile secondaryFile = issueLocationInterface.file() != null ? this.fileSystem.inputFile(this.fileSystem.predicates().is(issueLocationInterface.file())) : primaryFile;
            if (secondaryFile == null) continue;
            newIssue.addLocation(this.newLocation(secondaryFile, newIssue, issueLocationInterface));
        }
        newIssue.save();
    }

    private void saveLineIssueWithFlows(LineIssueWithFlows issue) {
        NewIssue newIssue = this.sensorContext.newIssue();
        InputFile primaryFile = this.getInputFile(issue.file());
        if (primaryFile == null) {
            this.cannotSaveIssue(issue);
            return;
        }
        NewIssueLocation primaryLocation = newIssue.newLocation().message(issue.message()).on((InputComponent)primaryFile).at(primaryFile.selectLine(issue.line()));
        newIssue.forRule(this.ruleKey(issue.check())).at(primaryLocation);
        if (issue.cost() != null) {
            newIssue.gap(issue.cost());
        }
        for (List<? extends IssueLocationInterface> flow : issue.flows()) {
            ArrayList<NewIssueLocation> updatedFlow = new ArrayList<NewIssueLocation>();
            for (IssueLocationInterface issueLocationInterface : flow) {
                if (FileUtils.contains(this.filesToAnalyze, issueLocationInterface.file())) {
                    InputFile issueFile = this.fileSystem.inputFile(this.fileSystem.predicates().is(issueLocationInterface.file()));
                    updatedFlow.add(this.newLocation(issueFile, newIssue, issueLocationInterface));
                    continue;
                }
                updatedFlow.add(this.newLocation(primaryFile, newIssue, new IssueLocation(issue.file(), issue.line(), String.format("%s. Issue location in a file not analyzed by Linty: %s, line %s", issueLocationInterface.message(), this.getRelativePathToProjectBaseDir(issueLocationInterface.file()), issueLocationInterface.startLine()))));
            }
            updatedFlow.add(primaryLocation);
            newIssue.addFlow(updatedFlow);
        }
        newIssue.save();
    }

    private NewIssueLocation newLocation(InputFile inputFile, NewIssue issue, IssueLocationInterface location) {
        NewIssueLocation newLocation;
        if (location.isLineLocation()) {
            newLocation = issue.newLocation().on((InputComponent)inputFile).at(inputFile.selectLine(location.startLine()));
        } else {
            TextRange range = inputFile.newRange(location.startLine(), location.startColumn(), location.endLine(), location.endColumn());
            newLocation = issue.newLocation().on((InputComponent)inputFile).at(range);
        }
        if (location.message() != null) {
            newLocation.message(location.message());
        }
        return newLocation;
    }

    private RuleKey ruleKey(Check check2) {
        Preconditions.checkNotNull(this.checks);
        RuleKey ruleKey = this.checks.getRuleKey(check2);
        if (ruleKey == null) {
            throw new LintyException("No rule key found for a rule");
        }
        return ruleKey;
    }

    private String getRelativePathToProjectBaseDir(File file) {
        return this.projectBaseDir.toPath().relativize(file.toPath()).toString();
    }

    private void cannotSaveIssue(IssueInterface issue) {
        LOG.warn("Linty cannot save the following issue. Please notify support@linty-services.com with the below message:");
        LOG.warn(issue.toString());
    }

    @Nullable
    private InputFile getInputFile(File file) {
        if (!this.hdlDesigner) {
            FilePredicate filePredicate = this.fileSystem.predicates().is(file);
            return this.fileSystem.inputFile(filePredicate);
        }
        for (InputFile inputFile : this.fileSystem.inputFiles(this.filesPredicate)) {
            if (!FileUtils.equals(file, new File(inputFile.uri()))) continue;
            return inputFile;
        }
        return null;
    }
}

