/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.linty.language.issues;

import com.google.common.base.Preconditions;
import com.lintyservices.sonar.plugins.linty.language.checks.Check;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueInterface;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class LineIssue
implements IssueInterface {
    private final Check check;
    private final File file;
    private final String message;
    private final int line;
    private Double cost;
    private final List<? extends IssueLocationInterface> secondaryLocations;

    public LineIssue(Check check2, File file, int line, String message) {
        Preconditions.checkArgument(line > 0);
        this.check = check2;
        this.file = file;
        this.message = message;
        this.line = line;
        this.cost = null;
        this.secondaryLocations = new ArrayList<IssueLocationInterface>();
    }

    public LineIssue(Check check2, File file, int line, String message, List<? extends IssueLocationInterface> secondaryLocations) {
        Preconditions.checkArgument(line > 0);
        this.check = check2;
        this.file = file;
        this.message = message;
        this.line = line;
        this.cost = null;
        this.secondaryLocations = secondaryLocations;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public Check check() {
        return this.check;
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    @Nullable
    public Double cost() {
        return this.cost;
    }

    @Override
    public IssueInterface cost(double cost) {
        this.cost = cost;
        return this;
    }

    public List<? extends IssueLocationInterface> secondaryLocations() {
        return this.secondaryLocations;
    }

    public String toString() {
        return String.format("Rule class: %s%nFile Path: %s%nLine: %d%n", this.check.getClass(), this.file.getAbsolutePath(), this.line);
    }
}

