/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.linty.language.issues;

import com.google.common.base.Preconditions;
import com.lintyservices.sonar.plugins.linty.language.checks.Check;
import com.lintyservices.sonar.plugins.linty.language.issues.IssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueInterface;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;

public class LineIssueWithFlows
implements IssueInterface {
    private final Check check;
    private final File file;
    private Double cost;
    private final String message;
    private final int line;
    private final List<List<? extends IssueLocationInterface>> flows;

    public LineIssueWithFlows(Check check2, File file, int line, String message, List<List<? extends IssueLocationInterface>> flows) {
        Preconditions.checkArgument(line > 0);
        this.check = check2;
        this.file = file;
        this.message = message;
        this.line = line;
        this.flows = flows;
        this.cost = null;
    }

    public LineIssueWithFlows(Check check2, IssueLocation primaryLocation, List<List<? extends IssueLocationInterface>> flows) {
        Preconditions.checkArgument(primaryLocation.startLine() > 0);
        this.check = check2;
        this.file = primaryLocation.file();
        this.message = primaryLocation.message();
        this.line = primaryLocation.startLine();
        this.flows = flows;
        this.cost = null;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public Check check() {
        return this.check;
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    @Nullable
    public Double cost() {
        return this.cost;
    }

    @Override
    public IssueInterface cost(double cost) {
        this.cost = cost;
        return this;
    }

    public List<List<? extends IssueLocationInterface>> flows() {
        return this.flows;
    }
}

