/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.linty.language.issues;

import com.lintyservices.sonar.plugins.linty.language.checks.Check;
import com.lintyservices.sonar.plugins.linty.language.issues.IssueLocation;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueInterface;
import com.lintyservices.sonar.plugins.linty.language.issues.interfaces.IssueLocationInterface;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class PreciseIssue
implements IssueInterface {
    private final Check check;
    private final IssueLocation primaryLocation;
    private final List<? extends IssueLocationInterface> secondaryLocations;
    private Double cost;

    public PreciseIssue(Check check2, IssueLocation primaryLocation) {
        this.check = check2;
        this.primaryLocation = primaryLocation;
        this.secondaryLocations = new ArrayList<IssueLocationInterface>();
        this.cost = null;
    }

    public PreciseIssue(Check check2, IssueLocation primaryLocation, List<? extends IssueLocationInterface> secondaryLocations) {
        this.check = check2;
        this.primaryLocation = primaryLocation;
        this.secondaryLocations = secondaryLocations;
        this.cost = null;
    }

    @Override
    public Check check() {
        return this.check;
    }

    @Override
    @Nullable
    public Double cost() {
        return this.cost;
    }

    @Override
    public PreciseIssue cost(double cost) {
        this.cost = cost;
        return this;
    }

    @Override
    public String message() {
        return this.primaryLocation.message();
    }

    @Override
    public File file() {
        return this.primaryLocation.file();
    }

    @Override
    public int line() {
        return this.primaryLocation.startLine();
    }

    public IssueLocation primaryLocation() {
        return this.primaryLocation;
    }

    public List<? extends IssueLocationInterface> secondaryLocations() {
        return this.secondaryLocations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PreciseIssue)) {
            return false;
        }
        PreciseIssue p = (PreciseIssue)o;
        return p.check.getClass().equals(this.check.getClass()) && p.primaryLocation.equals(this.primaryLocation);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.check.getClass().hashCode();
        result = 31 * result + this.primaryLocation.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder output = new StringBuilder(String.format("Rule class: %s%nPrimary Location:%n%s", this.check.getClass(), this.primaryLocation));
        if (!this.secondaryLocations.isEmpty()) {
            output.append("Secondary Locations:\n");
            for (IssueLocationInterface issueLocationInterface : this.secondaryLocations) {
                output.append(issueLocationInterface);
            }
        }
        return output.toString();
    }
}

