/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.linty.license;

import com.lintyservices.sonar.plugins.linty.license.LicenseCheckerException;
import com.lintyservices.sonar.plugins.linty.license.LicenseEncrypter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;

public class License {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final String company;
    private final String serverID;
    private final String type;
    private final String[] plugins;
    private final Date expirationDate;
    private final boolean bugFinder;
    private final boolean support;
    private final boolean vsCode;
    private final long ncloc;

    public License() throws LicenseCheckerException {
        throw new LicenseCheckerException("Linty license not found.");
    }

    public License(String encryptedLicenseKey) throws LicenseCheckerException {
        try {
            String decryptedLicense = new LicenseEncrypter().decrypt(encryptedLicenseKey);
            String[] splitDecryptedLicense = decryptedLicense.split(";");
            this.company = splitDecryptedLicense[0];
            this.serverID = splitDecryptedLicense[1];
            this.type = splitDecryptedLicense[2];
            this.plugins = splitDecryptedLicense[3].split(",");
            this.expirationDate = DATE_FORMAT.parse(splitDecryptedLicense[4]);
            this.bugFinder = Boolean.parseBoolean(splitDecryptedLicense[5]);
            this.support = Boolean.parseBoolean(splitDecryptedLicense[6]);
            this.vsCode = Boolean.parseBoolean(splitDecryptedLicense[7]);
            this.ncloc = Long.parseLong(splitDecryptedLicense[8]);
        }
        catch (Exception e) {
            throw new LicenseCheckerException("Linty license is invalid.");
        }
    }

    public License(String company, String serverID, String type, String plugins, String expirationDate, String bugFinder, String support, String vsCode, String ncloc) throws LicenseCheckerException {
        try {
            this.company = company;
            this.serverID = serverID;
            this.type = type;
            this.plugins = plugins.split(",");
            this.expirationDate = DATE_FORMAT.parse(expirationDate);
            this.bugFinder = Boolean.parseBoolean(bugFinder);
            this.support = Boolean.parseBoolean(support);
            this.vsCode = Boolean.parseBoolean(vsCode);
            this.ncloc = Long.parseLong(ncloc);
        }
        catch (Exception e) {
            throw new LicenseCheckerException("Linty license is invalid.");
        }
    }

    public String company() {
        return this.company;
    }

    public String serverID() {
        return this.serverID;
    }

    public String type() {
        return this.type;
    }

    public String[] plugins() {
        return this.plugins;
    }

    public Date expirationDate() {
        return this.expirationDate;
    }

    public boolean bugFinder() {
        return this.bugFinder;
    }

    public boolean support() {
        return this.support;
    }

    public boolean vsCode() {
        return this.vsCode;
    }

    public long ncloc() {
        return this.ncloc;
    }

    public void checkAll(@Nullable String actualServerID, long actualNcloc, String actualPlugin, boolean activeBugFinderRules) throws LicenseCheckerException {
        this.checkServerID(actualServerID);
        this.checkExpirationDate();
        this.checkPlugin(actualPlugin);
        this.checkNcloc(actualNcloc);
        this.checkBugFinder(activeBugFinderRules);
    }

    public void checkFromVsCode(String actualServerID, String actualPlugin) throws LicenseCheckerException {
        this.checkServerID(actualServerID);
        this.checkExpirationDate();
        this.checkPlugin(actualPlugin);
        this.checkVsCode();
    }

    public String encrypt() throws Exception {
        String licenseKey = String.join((CharSequence)";", List.of(this.company, this.serverID, this.type, String.join((CharSequence)",", this.plugins), DATE_FORMAT.format(this.expirationDate), String.valueOf(this.bugFinder), String.valueOf(this.support), String.valueOf(this.vsCode), String.valueOf(this.ncloc)));
        return new LicenseEncrypter().encrypt(licenseKey);
    }

    private void checkServerID(@Nullable String actualServerID) throws LicenseCheckerException {
        if (actualServerID == null) {
            throw new LicenseCheckerException("SonarQube Server ID could not be found.");
        }
        if (!actualServerID.equals(this.serverID)) {
            throw new LicenseCheckerException("SonarQube Server ID does not match license Server ID.\nActual: " + actualServerID + "\nExpected: " + this.serverID);
        }
    }

    private void checkExpirationDate() throws LicenseCheckerException {
        Date now = new Date();
        if (now.after(this.expirationDate)) {
            throw new LicenseCheckerException("Linty license has expired since " + DATE_FORMAT.format(this.expirationDate) + ".");
        }
    }

    private void checkPlugin(String plugin) throws LicenseCheckerException {
        if (Arrays.stream(this.plugins).noneMatch(p -> p.equals(plugin))) {
            throw new LicenseCheckerException("sonar-" + plugin + "-plugin is installed but your Linty license does not allow its usage.");
        }
    }

    private void checkNcloc(long actualNcloc) throws LicenseCheckerException {
        if (actualNcloc > this.ncloc) {
            throw new LicenseCheckerException("Too many lines of code have already been analyzed on your SonarQube platform.\nCurrent: " + actualNcloc + "\nMaximum: " + this.ncloc);
        }
    }

    private void checkBugFinder(boolean activeBugFinderRules) throws LicenseCheckerException {
        if (activeBugFinderRules && !this.bugFinder) {
            throw new LicenseCheckerException("Bug Finder rules are active but your Linty license does not allow its usage.");
        }
    }

    private void checkVsCode() throws LicenseCheckerException {
        if (!this.vsCode) {
            throw new LicenseCheckerException("Your Linty license does not allow usage from VS Code.");
        }
    }
}

