/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.helpers;

import com.lintyservices.sonar.plugins.hdl.issues.HdlIssues;
import com.lintyservices.sonar.plugins.hdl.visitors.ConfigAwareVisitor;
import com.lintyservices.sonar.plugins.hdl.visitors.CrossFileCheck;
import com.lintyservices.sonar.plugins.hdl.visitors.FilesToAnalyzeAwareVisitor;
import com.lintyservices.sonar.plugins.verilog.VerilogCheck;
import io.github.azagniotov.matcher.AntPathMatcher;
import java.io.File;
import java.util.Set;
import org.sonar.api.config.Configuration;
import org.sonar.check.Rule;

public abstract class SlangCrossFileCheck
implements VerilogCheck,
CrossFileCheck,
ConfigAwareVisitor,
FilesToAnalyzeAwareVisitor {
    private final HdlIssues issues = new HdlIssues(this);
    private Set<File> filesToAnalyze;
    private Configuration config;

    @Override
    public void setFilesToAnalyze(Set<File> filesToAnalyze) {
        this.filesToAnalyze = filesToAnalyze;
    }

    @Override
    public void setConfig(Configuration config) {
        this.config = config;
    }

    @Override
    public Configuration config() {
        return this.config;
    }

    public Set<File> filesToAnalyze() {
        return this.filesToAnalyze;
    }

    @Override
    public HdlIssues issues() {
        return this.issues;
    }

    @Override
    public void validateCheckParameters() {
    }

    public static String paramsErrorMessage(Class<? extends SlangCrossFileCheck> clazz, String errorMessage) {
        return "Check verilog:" + clazz.getAnnotation(Rule.class).key() + " : " + errorMessage;
    }

    @Override
    public void checkForIssues() {
        this.validateCheckParameters();
        this.issues().reset();
        this.retrieveIssues();
        this.issues().filterIssues(this.filesToAnalyze());
    }

    public abstract void retrieveIssues();

    public boolean isSimulationFile(File file) {
        String projectBaseDir = this.config.get("sonar.projectBaseDir").orElse("");
        String fileRelativePath = file.getAbsolutePath();
        if (!projectBaseDir.isEmpty()) {
            fileRelativePath = fileRelativePath.substring(projectBaseDir.length() + 1);
        }
        for (String pattern : this.config.getStringArray("sonar.hdl.file.simulationPaths")) {
            AntPathMatcher pathMatcher = new AntPathMatcher.Builder().build();
            if (!pathMatcher.isMatch(pattern, fileRelativePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isSynthesisFile(File file) {
        return !this.isSimulationFile(file);
    }

    public String topModule() {
        return this.config.get("sonar.hdl.topModule").orElse("");
    }

    public String ruleKey() {
        return this.getClass().getAnnotation(Rule.class).key();
    }
}

