/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.helpers;

import com.lintyservices.slang.helpers.Diagnostic;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.Diagnostics;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class SlangDiagnosticCheck
extends SlangCrossFileCheck
implements Diagnostics {
    private List<Diagnostic> diagnostics;

    @Override
    public void setDiagnostics(List<Diagnostic> diagnostics) {
        this.diagnostics = diagnostics;
    }

    @Override
    public void retrieveIssues() {
        List<Diagnostic> diags = this.diagnostics.stream().filter(d -> this.ids().contains(d.id())).toList();
        for (Diagnostic diagnostic : diags) {
            if (diagnostic.locationRange() != null) {
                this.issues().addPreciseIssue(diagnostic.locationRange(), this.message(diagnostic.message()), this.secondaryLocations(diagnostic.secondaryLocations()));
                continue;
            }
            this.issues().addLineIssue(diagnostic.location().file(), diagnostic.location().line(), this.message(diagnostic.message()), this.secondaryLocations(diagnostic.secondaryLocations()));
        }
    }

    public String message(String message) {
        return StringUtils.capitalize(message) + ".";
    }

    public String secondaryLocationMessage(String message) {
        return StringUtils.capitalize(message);
    }

    public abstract Set<String> ids();

    public List<HdlIssueLocation> secondaryLocations(List<Diagnostic> diagnostics) {
        return diagnostics.stream().map(s -> {
            if (s.locationRange() != null) {
                return new HdlIssueLocation(s.locationRange(), this.secondaryLocationMessage(s.message()));
            }
            return new HdlIssueLocation(s.location(), this.secondaryLocationMessage(s.message()));
        }).toList();
    }
}

