/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.helpers;

import com.lintyservices.slang.helpers.Identified;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public abstract class UniqueObjectNameCheck
extends SlangCrossFileCheck
implements FreeHdlDesignerCheck {
    private final List<Identified> identifiers = new ArrayList<Identified>();

    public void addIdentifiers(List<Identified> identifiers) {
        this.identifiers.addAll(identifiers);
    }

    @Override
    public final void retrieveIssues() {
        this.identifiers.stream().collect(Collectors.groupingBy(m -> m.identifier().text(), Collectors.toList())).forEach((key, value) -> {
            if (value.size() > 1) {
                List identifiersWithSameName = value.stream().sorted(Comparator.comparing(i -> i.identifier().location())).collect(Collectors.toList());
                Identified firstIdentifier = (Identified)identifiersWithSameName.get(0);
                identifiersWithSameName.remove(0);
                List<HdlIssueLocation> secondaryLocations = identifiersWithSameName.stream().map(d -> new HdlIssueLocation(d.identifier(), "Duplicated name")).toList();
                this.issues().addPreciseIssue(firstIdentifier.identifier(), String.format("Rename %s '%s' to avoid confusion.", this.getObjectName(), firstIdentifier.identifier().text()), secondaryLocations);
            }
        });
    }

    public abstract String getObjectName();
}

