/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.trees.ConfigurationDeclaration;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.ConfigurationDeclarations;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG038")
public class ConfigurationNamingConventionCheck
extends SlangCrossFileCheck
implements ConfigurationDeclarations,
HdlDesignerCheck {
    private static final String DEFAULT_FORMAT = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    private List<ConfigurationDeclaration> configurationDeclarations;
    @RuleProperty(key="format", description="Regular expression to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$", type="REGULAR_EXPRESSION")
    public String format = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";

    @Override
    public void setConfigurationDeclarations(List<ConfigurationDeclaration> configurationDeclarations) {
        this.configurationDeclarations = configurationDeclarations;
    }

    @Override
    public void retrieveIssues() {
        Pattern pattern = Pattern.compile(this.format, 32);
        for (ConfigurationDeclaration declaration : this.configurationDeclarations) {
            if (pattern.matcher(declaration.identifier().text()).matches()) continue;
            this.issues().addPreciseIssue(declaration.identifier(), String.format("Rename configuration '%s' to match the following regular expression: %s", declaration.identifier().text(), this.format));
        }
    }
}

