/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.trees.ConstraintDeclaration;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.ConstraintDeclarations;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG069")
public class ConstraintNamingConventionCheck
extends SlangCrossFileCheck
implements ConstraintDeclarations,
HdlDesignerCheck {
    private static final String DEFAULT_FORMAT = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";
    private List<ConstraintDeclaration> constraintDeclarations;
    @RuleProperty(key="format", description="Regular expression to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", defaultValue="^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$", type="REGULAR_EXPRESSION")
    public String format = "^[a-z]|[a-z]+[a-z0-9_]*[a-z0-9]+$";

    @Override
    public void setConstraintDeclarations(List<ConstraintDeclaration> constraintDeclarations) {
        this.constraintDeclarations = constraintDeclarations;
    }

    @Override
    public void retrieveIssues() {
        Pattern pattern = Pattern.compile(this.format, 32);
        this.constraintDeclarations.forEach(d -> {
            if (!pattern.matcher(d.identifier().text()).matches()) {
                this.issues().addPreciseIssue(d.identifier(), String.format("Rename constraint '%s' to match the following regular expression: %s", d.identifier().text(), this.format));
            }
        });
    }
}

