/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.slang.trees.ImplicitAnsiPort;
import com.lintyservices.slang.trees.ImplicitNonAnsiPort;
import com.lintyservices.slang.trees.ModuleDeclaration;
import com.lintyservices.slang.trees.ParameterDeclaration;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.ImplicitAnsiPorts;
import com.lintyservices.sonar.plugins.verilog.slang.data.ImplicitNonAnsiPorts;
import com.lintyservices.sonar.plugins.verilog.slang.data.ModuleDeclarations;
import com.lintyservices.sonar.plugins.verilog.slang.data.ParameterDeclarations;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VERILOG071")
public class CppKeywordCheck
extends SlangCrossFileCheck
implements ModuleDeclarations,
ParameterDeclarations,
ImplicitAnsiPorts,
ImplicitNonAnsiPorts {
    public static final List<String> CPP_KEYWORDS = List.of("alignas", "alignof", "and", "and_eq", "asm", "atomic_cancel", "atomic_commit", "atomic_noexcept", "auto", "bitand", "bitor", "bool", "break", "case", "catch", "char", "char16_t", "char32_t", "char8_t", "class", "co_await", "co_return", "co_yield", "compl", "concept", "const", "const_cast", "consteval", "constexpr", "constinit", "continue", "decltype", "default", "delete", "do", "double", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "if", "inline", "int", "long", "mutable", "namespace", "new", "noexcept", "not", "not_eq", "nullptr", "operator", "or", "or_eq", "private", "protected", "public", "reflexpr", "register", "reinterpret_cast", "requires", "return", "short", "signed", "sizeof", "static", "static_assert", "static_cast", "struct", "switch", "synchronized", "template", "this", "thread_local", "throw", "true", "try", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "xor", "xor_eq");
    private List<ModuleDeclaration> moduleDeclarations;
    private List<ImplicitAnsiPort> ansiPorts;
    private List<ImplicitNonAnsiPort> nonAnsiPorts;
    private List<ParameterDeclaration> parameterDeclarations;

    @Override
    public void setModuleDeclarations(List<ModuleDeclaration> moduleDeclarations) {
        this.moduleDeclarations = moduleDeclarations;
    }

    @Override
    public void setImplicitAnsiPorts(List<ImplicitAnsiPort> ports) {
        this.ansiPorts = ports;
    }

    @Override
    public void setImplicitNonAnsiPorts(List<ImplicitNonAnsiPort> ports) {
        this.nonAnsiPorts = ports;
    }

    @Override
    public void setParameterDeclarations(List<ParameterDeclaration> parameterDeclarations) {
        this.parameterDeclarations = parameterDeclarations;
    }

    @Override
    public void retrieveIssues() {
        for (ModuleDeclaration moduleDeclaration : this.moduleDeclarations) {
            this.checkForIssue(moduleDeclaration.identifier());
        }
        for (ImplicitAnsiPort implicitAnsiPort : this.ansiPorts) {
            this.checkForIssue(implicitAnsiPort.identifier());
        }
        for (ImplicitNonAnsiPort implicitNonAnsiPort : this.nonAnsiPorts) {
            this.checkForIssue(implicitNonAnsiPort.identifier());
        }
        for (ParameterDeclaration parameterDeclaration : this.parameterDeclarations) {
            for (SyntaxNode name : parameterDeclaration.names()) {
                this.checkForIssue(name);
            }
        }
    }

    private void checkForIssue(SyntaxNode node) {
        if (CPP_KEYWORDS.contains(node.text().toLowerCase())) {
            this.issues().addPreciseIssue(node, "Rename this identifier to not match a C++ keyword.");
        }
    }
}

