/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxKinds;
import com.lintyservices.slang.trees.DefineDirective;
import com.lintyservices.slang.trees.Directive;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.Directives;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG066")
public class DefineMacroNamingConventionCheck
extends SlangCrossFileCheck
implements Directives,
HdlDesignerCheck {
    private static final String DEFAULT_FORMAT = "^[A-Z0-9_]+$";
    private List<DefineDirective> directives;
    @RuleProperty(key="format", description="Regular expression to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^[A-Z0-9_]+$")
    public String format = "^[A-Z0-9_]+$";

    @Override
    public void setDirectives(List<Directive> directives) {
        this.directives = directives.stream().filter(d -> d.kind() == SyntaxKinds.DefineDirective).map(d -> new DefineDirective(d.node())).toList();
    }

    @Override
    public void retrieveIssues() {
        Pattern pattern = Pattern.compile(this.format, 32);
        for (DefineDirective directive : this.directives) {
            if (pattern.matcher(directive.identifier().text()).matches()) continue;
            this.issues().addPreciseIssue(directive.identifier(), String.format("Rename define macro '%s' to match the following regular expression: %s", directive.identifier().text(), this.format));
        }
    }
}

