/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.trees.NonAnsiPortList;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.NonAnsiPortLists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VERILOG096")
public class EmptyNonAnsiPortCheck
extends SlangCrossFileCheck
implements NonAnsiPortLists,
FreeHdlDesignerCheck {
    private List<NonAnsiPortList> portListsWithEmptyPorts = new ArrayList<NonAnsiPortList>();

    @Override
    public void setNonAnsiPortLists(List<NonAnsiPortList> portLists) {
        this.portListsWithEmptyPorts = portLists.stream().filter(NonAnsiPortList::hasEmptyPorts).toList();
    }

    @Override
    public void retrieveIssues() {
        for (NonAnsiPortList portList : this.portListsWithEmptyPorts) {
            this.issues().addPreciseIssue(portList, "Remove empty port(s) from this port list.");
        }
    }
}

