/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.metrics.Comment;
import com.lintyservices.sonar.plugins.verilog.metrics.CommentLinesComputer;
import com.lintyservices.sonar.plugins.verilog.slang.data.AllTokensAndDirectivesByFile;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;

@Rule(key="VERILOG013")
public class FileHeaderCheck
extends SlangCrossFileCheck
implements AllTokensAndDirectivesByFile,
HdlDesignerCheck {
    private Map<File, List<SyntaxNode>> allTokensAndDirectivesByFile;

    @Override
    public void setAllTokensAndDirectivesByFile(Map<File, List<SyntaxNode>> allTokensAndDirectivesByFile) {
        this.allTokensAndDirectivesByFile = allTokensAndDirectivesByFile;
    }

    @Override
    public void retrieveIssues() {
        for (Map.Entry<File, List<SyntaxNode>> entry : this.allTokensAndDirectivesByFile.entrySet()) {
            if (!new CommentLinesComputer(entry.getValue()).getComments().stream().noneMatch(Comment::isHeader)) continue;
            this.issues().addFileIssue(entry.getKey(), "Add a header to this file.");
        }
    }
}

