/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.trees.SystemName;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.SystemNames;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;

@Rule(key="VERILOG034")
public class ForbiddenSystemTasksAndFunctionsCheck
extends SlangCrossFileCheck
implements SystemNames,
FreeHdlDesignerCheck {
    private List<SystemName> systemNames;

    @Override
    public void setSystemNames(List<SystemName> systemNames) {
        this.systemNames = systemNames;
    }

    @Override
    public void retrieveIssues() {
        for (SystemName systemName : this.systemNames) {
            if (!Set.of("$psprintf", "$random", "$srandom").contains(systemName.node().text()) && !systemName.node().text().startsWith("$dist_")) continue;
            this.issues().addPreciseIssue(systemName, "Replace this forbidden system task/function.");
        }
    }
}

