/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.slang.trees.GenerateBlock;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.GenerateBlocks;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG047")
public class GenerateBlockLabelNamingConventionCheck
extends SlangCrossFileCheck
implements GenerateBlocks,
HdlDesignerCheck {
    public static final String DEFAULT_FORMAT = "^(gen_|g)[a-z0-9_]+$";
    private List<GenerateBlock> generateBlocks;
    @RuleProperty(key="format", description="Regular expression for generate block labels to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", type="REGULAR_EXPRESSION", defaultValue="^(gen_|g)[a-z0-9_]+$")
    public String format = "^(gen_|g)[a-z0-9_]+$";

    @Override
    public void setGenerateBlocks(List<GenerateBlock> generateBlocks) {
        this.generateBlocks = generateBlocks;
    }

    @Override
    public void retrieveIssues() {
        Pattern pattern = Pattern.compile(this.format, 32);
        for (GenerateBlock block : this.generateBlocks) {
            SyntaxNode label;
            if (block.labelAfterBegin() == null && block.labelBeforeBegin() == null || pattern.matcher((label = block.labelAfterBegin() != null ? block.labelAfterBegin() : block.labelBeforeBegin()).text()).matches()) continue;
            this.issues().addPreciseIssue(label, String.format("Rename this label to match the following regular expression: %s", this.format));
        }
    }
}

