/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.LocationRange;
import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.Tokens;
import com.lintyservices.utils.LintyException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tika.langdetect.optimaize.OptimaizeLangDetector;
import org.apache.tika.language.detect.LanguageDetector;
import org.apache.tika.language.detect.LanguageResult;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG004")
public class LanguageCheck
extends SlangCrossFileCheck
implements Tokens,
HdlDesignerCheck {
    private static final String DEFAULT_LANGUAGE = "ENGLISH";
    private static final List<String> SUPPORTED_LANGUAGES = List.of("ENGLISH", "FRENCH", "GERMAN", "ITALIAN", "PORTUGUESE", "SPANISH");
    private static final Map<String, String> LANGUAGE_MATCH = Map.of("ENGLISH", "en", "FRENCH", "fr", "GERMAN", "de", "ITALIAN", "it", "PORTUGUESE", "pt", "SPANISH", "es");
    private List<SyntaxNode> tokens;
    @RuleProperty(key="language", description="Possible values: ENGLISH, FRENCH, GERMAN, ITALIAN, PORTUGUESE, SPANISH", defaultValue="ENGLISH")
    public String language = "ENGLISH";

    @Override
    public void setTokens(List<SyntaxNode> tokens) {
        this.tokens = tokens;
    }

    @Override
    public void retrieveIssues() {
        for (SyntaxNode token : this.tokens) {
            List<SyntaxNode.Trivia> commentTrivia = token.getComments();
            if (commentTrivia.isEmpty()) continue;
            this.checkForIssues(commentTrivia);
        }
    }

    @Override
    public void validateCheckParameters() {
        if (!SUPPORTED_LANGUAGES.contains(this.language.toUpperCase())) {
            throw new LintyException(LanguageCheck.paramsErrorMessage(this.getClass(), String.format("language parameter \"%s\" is not a valid language. Possible values are: %s.", this.language, String.join((CharSequence)", ", SUPPORTED_LANGUAGES))));
        }
    }

    private void checkForIssues(List<SyntaxNode.Trivia> commentTrivia) {
        List<SyntaxNode.Trivia> remainingCommentTrivia = commentTrivia;
        while (!remainingCommentTrivia.isEmpty()) {
            LanguageDetector detector;
            LanguageResult result;
            List<SyntaxNode.Trivia> consecutiveCommentTrivia = this.consecutiveComments(remainingCommentTrivia);
            String actualComment = this.actualComment(consecutiveCommentTrivia);
            if (this.shouldCommentBeChecked(actualComment) && !(result = (detector = new OptimaizeLangDetector().loadModels()).detect(actualComment)).getLanguage().equals(LANGUAGE_MATCH.get(this.language.toUpperCase()))) {
                this.issues().addPreciseIssue(this.issueLocation(consecutiveCommentTrivia), String.format("Write this comment in %s or remove this commented-out code.", this.language.toLowerCase()));
            }
            if (consecutiveCommentTrivia.size() >= remainingCommentTrivia.size()) {
                remainingCommentTrivia = new ArrayList<SyntaxNode.Trivia>();
                continue;
            }
            remainingCommentTrivia = remainingCommentTrivia.subList(consecutiveCommentTrivia.size(), remainingCommentTrivia.size());
        }
    }

    private String actualComment(List<SyntaxNode.Trivia> commentTrivia) {
        return commentTrivia.stream().map(SyntaxNode.Trivia::text).map(t -> t.replace("/", "")).map(t -> t.replace("*", "")).collect(Collectors.joining(" "));
    }

    private List<SyntaxNode.Trivia> consecutiveComments(List<SyntaxNode.Trivia> comments) {
        int lastCommentLine = -1;
        ArrayList<SyntaxNode.Trivia> consecutiveComments = new ArrayList<SyntaxNode.Trivia>();
        for (SyntaxNode.Trivia comment : comments) {
            if (lastCommentLine != -1 && comment.location().line() != lastCommentLine + 1) break;
            consecutiveComments.add(comment);
            lastCommentLine = comment.location().endLine();
        }
        return consecutiveComments;
    }

    private LocationRange issueLocation(List<SyntaxNode.Trivia> comments) {
        LocationRange firstTriviaLocation = comments.get(0).location();
        LocationRange lastTriviaLocation = comments.get(comments.size() - 1).location();
        return new LocationRange(firstTriviaLocation.file(), firstTriviaLocation.line(), firstTriviaLocation.column(), lastTriviaLocation.endLine(), lastTriviaLocation.endColumn());
    }

    private boolean shouldCommentBeChecked(String comment) {
        return this.countWords(comment) > 10;
    }

    private int countWords(String input) {
        if (input.isEmpty()) {
            return 0;
        }
        String[] words = input.split("\\s+");
        return words.length;
    }
}

