/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.Comments;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG041")
public class MatchKeywordsInCommentsCheck
extends SlangCrossFileCheck
implements Comments,
HdlDesignerCheck {
    private static final String DEFAULT_KEYWORDS = "Requirement";
    private List<SyntaxNode.Trivia> comments;
    @RuleProperty(key="keywords", description="Comma-separated list of keywords to match. It matches comments whatever the case of keywords.", defaultValue="Requirement")
    public String keywords = "Requirement";

    @Override
    public void setComments(List<SyntaxNode.Trivia> comments) {
        this.comments = comments;
    }

    @Override
    public void retrieveIssues() {
        List<String> keywordsAsList = Arrays.stream(this.keywords.split(",")).map(String::trim).map(String::toLowerCase).toList();
        for (SyntaxNode.Trivia comment : this.comments) {
            for (String keyword : keywordsAsList) {
                if (!StringUtils.containsIgnoreCase(comment.text(), keyword) || MatchKeywordsInCommentsCheck.isLetterAround(comment.text(), keyword)) continue;
                this.issues().addPreciseIssue(comment, "Match one of the keywords in comments.");
            }
        }
    }

    private static boolean isLetterAround(String line, String pattern) {
        int start = StringUtils.indexOfIgnoreCase(line, pattern);
        int end = start + pattern.length();
        boolean pre = start > 0 && Character.isLetter(line.charAt(start - 1));
        boolean post = end < line.length() - 1 && Character.isLetter(line.charAt(end));
        return pre || post;
    }
}

