/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.trees.HierarchicalInstance;
import com.lintyservices.slang.trees.HierarchyInstantiation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.HierarchyInstantiations;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG100")
public class ModuleInstantiationNamingConventionCheck
extends SlangCrossFileCheck
implements HierarchyInstantiations,
HdlDesignerCheck {
    private List<HierarchyInstantiation> hierarchyInstantiations;
    private static final String DEFAULT_FORMAT = "^i_[a-z0-9_]+$";
    @RuleProperty(key="format", description="Regular expression to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", defaultValue="^i_[a-z0-9_]+$", type="REGULAR_EXPRESSION")
    public String format = "^i_[a-z0-9_]+$";

    @Override
    public void setHierarchyInstantiations(List<HierarchyInstantiation> hierarchyInstantiations) {
        this.hierarchyInstantiations = hierarchyInstantiations;
    }

    @Override
    public void retrieveIssues() {
        Pattern pattern = Pattern.compile(this.format, 32);
        for (HierarchyInstantiation instantiation : this.hierarchyInstantiations) {
            for (HierarchicalInstance instance : instantiation.instances()) {
                if (pattern.matcher(instance.identifier().text()).matches()) continue;
                this.issues().addPreciseIssue(instance.identifier(), String.format("Rename module instantiation '%s' to match the following regular expression: %s", instance.identifier().text(), this.format));
            }
        }
    }
}

