/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxKinds;
import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.slang.trees.AnsiPortList;
import com.lintyservices.slang.trees.GenericModuleDeclaration;
import com.lintyservices.slang.trees.InterfaceDeclaration;
import com.lintyservices.slang.trees.ModuleDeclaration;
import com.lintyservices.slang.trees.NonAnsiPortList;
import com.lintyservices.slang.trees.PortList;
import com.lintyservices.slang.trees.ProgramDeclaration;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.AnsiPortLists;
import com.lintyservices.sonar.plugins.verilog.slang.data.NonAnsiPortLists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG098")
public class ModuleTooManyPortsCheck
extends SlangCrossFileCheck
implements AnsiPortLists,
NonAnsiPortLists,
HdlDesignerCheck {
    private static final int DEFAULT_MAX_NUMBER_OF_PORTS = 6;
    private static final boolean DEFAULT_CHECK_TOP_MODULE = false;
    private List<NonAnsiPortList> nonAnsiPortLists = new ArrayList<NonAnsiPortList>();
    private List<AnsiPortList> ansiPortLists = new ArrayList<AnsiPortList>();
    @RuleProperty(key="max", description="The maximum allowed number of ports.", type="INTEGER", defaultValue="6")
    public int max = 6;
    @RuleProperty(key="checkTopModule", description="Set to 'true', to check this rule on top module, set to 'false' otherwise.", type="BOOLEAN", defaultValue="false")
    public boolean checkTopModule = false;

    @Override
    public void setAnsiPortLists(List<AnsiPortList> portLists) {
        this.ansiPortLists = portLists;
    }

    @Override
    public void setNonAnsiPortLists(List<NonAnsiPortList> portLists) {
        this.nonAnsiPortLists = portLists;
    }

    @Override
    public void retrieveIssues() {
        for (NonAnsiPortList nonAnsiPortList : this.nonAnsiPortLists) {
            this.checkForIssue(nonAnsiPortList);
        }
        for (AnsiPortList ansiPortList : this.ansiPortLists) {
            this.checkForIssue(ansiPortList);
        }
    }

    private void checkForIssue(PortList portList) {
        if (portList.ports().size() > this.max) {
            if (this.checkTopModule) {
                this.raiseIssue(portList);
            } else if (portList.parent().parent().kind() == SyntaxKinds.ModuleDeclaration) {
                String moduleName = new ModuleDeclaration(portList.parent().parent()).identifier().text();
                if (!moduleName.equals(this.topModule())) {
                    this.raiseIssue(portList);
                }
            } else {
                this.raiseIssue(portList);
            }
        }
    }

    private void raiseIssue(PortList portList) {
        GenericModuleDeclaration primaryTree;
        SyntaxNode primarySyntaxNode = portList.parent().parent();
        if (primarySyntaxNode.kind() == SyntaxKinds.ModuleDeclaration) {
            primaryTree = new ModuleDeclaration(primarySyntaxNode);
        } else if (primarySyntaxNode.kind() == SyntaxKinds.InterfaceDeclaration) {
            primaryTree = new InterfaceDeclaration(primarySyntaxNode);
        } else if (primarySyntaxNode.kind() == SyntaxKinds.ProgramDeclaration) {
            primaryTree = new ProgramDeclaration(primarySyntaxNode);
        } else {
            return;
        }
        this.issues().addPreciseIssue(primaryTree.identifier(), String.format("Too many ports. Actual: %d. Allowed: %d. Split this %s into single-responsibility %ss.", portList.ports().size(), this.max, primaryTree.humanReadableKind(), primaryTree.humanReadableKind()), List.of(new HdlIssueLocation(portList, "Port list")));
    }
}

