/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxKinds;
import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.slang.trees.ConditionalExpression;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.ConditionalExpressions;
import java.util.List;
import org.sonar.check.Rule;

@Rule(key="VERILOG102")
public class NestedConditionalExpressionsCheck
extends SlangCrossFileCheck
implements ConditionalExpressions,
HdlDesignerCheck {
    private List<ConditionalExpression> conditionalExpressions;

    @Override
    public void setConditionalExpressions(List<ConditionalExpression> conditionalExpressions) {
        this.conditionalExpressions = conditionalExpressions;
    }

    @Override
    public void retrieveIssues() {
        for (ConditionalExpression conditionalExpression : this.conditionalExpressions) {
            List<HdlIssueLocation> nestedConditionalExpressions;
            if (conditionalExpression.hasAncestor(SyntaxKinds.ConditionalExpression) || (nestedConditionalExpressions = conditionalExpression.node().search(SyntaxKinds.ConditionalExpression).stream().map(s -> new HdlIssueLocation(new ConditionalExpression((SyntaxNode)s).location(), "Nested ternary expression")).toList()).isEmpty()) continue;
            this.issues().addPreciseIssue(conditionalExpression, "Remove all nested ternary expressions.", nestedConditionalExpressions);
        }
    }
}

