/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.trees.DesignUnitDeclaration;
import com.lintyservices.sonar.plugins.hdl.issues.HdlIssueLocation;
import com.lintyservices.sonar.plugins.linty.language.checks.FreeHdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.DesignUnitDeclarations;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;

@Rule(key="VERILOG028")
public class OneDesignUnitPerFileCheck
extends SlangCrossFileCheck
implements DesignUnitDeclarations,
FreeHdlDesignerCheck {
    private Map<File, List<DesignUnitDeclaration>> declarations;

    @Override
    public void setDesignUnitDeclarations(List<DesignUnitDeclaration> designUnitDeclarations) {
        this.declarations = designUnitDeclarations.stream().collect(Collectors.groupingBy(d -> d.location().file()));
    }

    @Override
    public void retrieveIssues() {
        for (Map.Entry<File, List<DesignUnitDeclaration>> entry : this.declarations.entrySet()) {
            int numberOfDesignUnits = entry.getValue().size();
            if (numberOfDesignUnits <= 1) continue;
            ArrayList<HdlIssueLocation> secondaryLocations = new ArrayList<HdlIssueLocation>();
            for (int i = 0; i < numberOfDesignUnits - 1; ++i) {
                secondaryLocations.add(new HdlIssueLocation(entry.getValue().get(i).identifier(), "Design unit"));
            }
            this.issues().addPreciseIssue(entry.getValue().get(numberOfDesignUnits - 1).identifier(), "Keep only one single design unit in this file.", secondaryLocations);
        }
    }
}

