/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.slang.trees.ParameterDeclaration;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.ParameterDeclarations;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG078")
public class ParameterNamingConventionCheck
extends SlangCrossFileCheck
implements ParameterDeclarations,
HdlDesignerCheck {
    private static final String DEFAULT_FORMAT = "^[A-Z]|[A-Z]+[A-Z0-9_]*[A-Z0-9]+$";
    private List<ParameterDeclaration> parameterDeclarations;
    @RuleProperty(key="format", description="Regular expression to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", defaultValue="^[A-Z]|[A-Z]+[A-Z0-9_]*[A-Z0-9]+$", type="REGULAR_EXPRESSION")
    public String format = "^[A-Z]|[A-Z]+[A-Z0-9_]*[A-Z0-9]+$";

    @Override
    public void setParameterDeclarations(List<ParameterDeclaration> parameterDeclarations) {
        this.parameterDeclarations = parameterDeclarations.stream().filter(d -> d.keyword() == null || "parameter".equals(d.keyword().text())).toList();
    }

    @Override
    public void retrieveIssues() {
        Pattern pattern = Pattern.compile(this.format, 32);
        for (ParameterDeclaration declaration : this.parameterDeclarations) {
            for (SyntaxNode name : declaration.names()) {
                if (pattern.matcher(name.text()).matches()) continue;
                this.issues().addPreciseIssue(name, String.format("Rename parameter '%s' to match the following regular expression: %s", name.text(), this.format));
            }
        }
    }
}

