/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.slang.trees.ParameterDeclaration;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.ParameterDeclarations;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG073")
public class ParameterPositiveMeaningCheck
extends SlangCrossFileCheck
implements ParameterDeclarations,
HdlDesignerCheck {
    private static final String DEFAULT_NEGATIVE_MEANING_WORDS = "disable,deactivate";
    private List<ParameterDeclaration> parameterDeclarations;
    @RuleProperty(key="negativeMeaningWords", description="Comma-separated list of words to avoid (case-independent)", defaultValue="disable,deactivate")
    public String negativeMeaningWords = "disable,deactivate";

    @Override
    public void setParameterDeclarations(List<ParameterDeclaration> parameterDeclarations) {
        this.parameterDeclarations = parameterDeclarations;
    }

    @Override
    public void retrieveIssues() {
        for (ParameterDeclaration declaration : this.parameterDeclarations) {
            for (SyntaxNode name : declaration.names()) {
                if (!this.hasNegativeMeaning(name.text())) continue;
                this.issues().addPreciseIssue(name, "Use positive meaning instead.");
            }
        }
    }

    private boolean hasNegativeMeaning(String name) {
        return Stream.of(this.negativeMeaningWords.toLowerCase().trim().split("\\s*,\\s*")).collect(Collectors.toSet()).stream().anyMatch(name.toLowerCase()::contains);
    }
}

