/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.slang.trees.TypeParameterDeclaration;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.TypeParameterDeclarations;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;

@Rule(key="VERILOG079")
public class TypeParameterNamingConventionCheck
extends SlangCrossFileCheck
implements TypeParameterDeclarations,
HdlDesignerCheck {
    public static final String DEFAULT_FORMAT = "^[a-z]+[a-z0-9_]*_t$";
    private List<TypeParameterDeclaration> typeParameterDeclarations;
    @RuleProperty(key="format", description="Regular expression to match.\nSee documentation at https://tinyurl.com/y37njdz2 and online regex checker at https://regex101.com", defaultValue="^[a-z]+[a-z0-9_]*_t$", type="REGULAR_EXPRESSION")
    public String format = "^[a-z]+[a-z0-9_]*_t$";

    @Override
    public void setTypeParameterDeclarations(List<TypeParameterDeclaration> typeParameterDeclarations) {
        this.typeParameterDeclarations = typeParameterDeclarations;
    }

    @Override
    public void retrieveIssues() {
        Pattern pattern = Pattern.compile(this.format, 32);
        for (TypeParameterDeclaration declaration : this.typeParameterDeclarations) {
            for (SyntaxNode name : declaration.names()) {
                if (pattern.matcher(name.text()).matches()) continue;
                this.issues().addPreciseIssue(name, String.format("Rename type parameter '%s' to match the following regular expression: %s", name.text(), this.format));
            }
        }
    }
}

