/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.checks.linter;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.sonar.plugins.linty.language.checks.HdlDesignerCheck;
import com.lintyservices.sonar.plugins.verilog.checks.helpers.SlangCrossFileCheck;
import com.lintyservices.sonar.plugins.verilog.slang.data.Comments;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;

@Rule(key="VERILOG093")
public class VerilatorLintOffOnCheck
extends SlangCrossFileCheck
implements Comments,
HdlDesignerCheck {
    private List<SyntaxNode.Trivia> comments;

    @Override
    public void setComments(List<SyntaxNode.Trivia> comments) {
        this.comments = comments;
    }

    @Override
    public void retrieveIssues() {
        Pattern pattern = Pattern.compile("verilator\\s+lint_(on|off)", 32);
        for (SyntaxNode.Trivia comment : this.comments) {
            Matcher matcher = pattern.matcher(comment.text());
            if (!matcher.find()) continue;
            this.issues().addPreciseIssue(comment, String.format("Remove this usage of verilator lint_%s.", matcher.group(1)));
        }
    }
}

