/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.computers;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.sonar.plugins.verilog.metrics.CommentLinesComputer;
import com.lintyservices.sonar.plugins.verilog.metrics.LinesOfCodesComputer;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;

public class VerilogMetricsComputer {
    public static final Logger LOG = LoggerFactory.getLogger(VerilogMetricsComputer.class);

    public VerilogMetricsComputer(Map<File, List<SyntaxNode>> tokens, SensorContext context) {
        LOG.info("Computing metrics...");
        for (Map.Entry<File, List<SyntaxNode>> entry : tokens.entrySet()) {
            this.saveMetricOnFile(CoreMetrics.NCLOC, new LinesOfCodesComputer(entry.getValue()).getNumberOfLinesOfCode(), entry.getKey(), context);
            this.saveMetricOnFile(CoreMetrics.COMMENT_LINES, new CommentLinesComputer(entry.getValue()).getNumberOfCommentLines(), entry.getKey(), context);
        }
        LOG.info("Computing metrics: Done");
    }

    private <T extends Serializable> void saveMetricOnFile(Metric<T> metric, T value, File file, SensorContext context) {
        context.newMeasure().forMetric(metric).on((InputComponent)context.fileSystem().inputFile(context.fileSystem().predicates().is(file))).withValue(value).save();
    }
}

