/*
 * Decompiled with CFR 0.152.
 */
package com.lintyservices.sonar.plugins.verilog.metrics;

import com.lintyservices.slang.helpers.SyntaxNode;
import com.lintyservices.sonar.plugins.verilog.metrics.Comment;
import com.lintyservices.sonar.plugins.verilog.metrics.CommentAnalyzer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CommentLinesComputer {
    private final Set<Integer> commentLines = new HashSet<Integer>();
    private final List<Comment> comments = new ArrayList<Comment>();
    private final CommentAnalyzer commentAnalyzer = new CommentAnalyzer();

    public CommentLinesComputer(List<SyntaxNode> tokensAndDirectives) {
        boolean inHeader = true;
        int previousTokenLine = -1;
        int previousCommentLine = 0;
        for (SyntaxNode token : tokensAndDirectives) {
            for (SyntaxNode.Trivia triviaComment : token.getComments()) {
                if (inHeader && triviaComment.location().line() - previousCommentLine > 1) {
                    inHeader = false;
                }
                this.comments.add(new Comment(triviaComment, inHeader, triviaComment.location().line() == previousTokenLine));
                previousCommentLine = triviaComment.location().line();
                if (inHeader) continue;
                this.handleCommentsForTrivia(triviaComment);
            }
            previousTokenLine = token.location().line();
            inHeader = false;
        }
    }

    public Set<Integer> getCommentLines() {
        return this.commentLines;
    }

    public int getNumberOfCommentLines() {
        return this.commentLines.size();
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    private void handleCommentsForTrivia(SyntaxNode.Trivia trivia) {
        String[] lineContents = this.commentAnalyzer.getContents(trivia.text()).split("(\r)?\n|\r", -1);
        int lineNumber = trivia.location().line();
        for (String lineContent : lineContents) {
            if (!this.commentAnalyzer.isBlank(lineContent)) {
                this.commentLines.add(lineNumber);
            }
            ++lineNumber;
        }
    }
}

